/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.IPageLink;
import org.apache.wicket.markup.html.link.Link;

public class PageLink
extends Link {
    private static final long serialVersionUID = 1L;
    private final IPageLink pageLink;

    public PageLink(String id, final Class c) {
        super(id);
        if (!Page.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c + " is not a subclass of Page");
        }
        this.pageLink = new IPageLink(){
            private static final long serialVersionUID = 1L;

            public Page getPage() {
                return PageLink.this.getPage().getPageFactory().newPage(c);
            }

            public Class getPageIdentity() {
                return c;
            }
        };
    }

    public PageLink(String id, IPageLink pageLink) {
        super(id);
        this.pageLink = pageLink;
    }

    public PageLink(String id, final Page page) {
        super(id);
        this.pageLink = new IPageLink(){
            private static final long serialVersionUID = 1L;

            public Page getPage() {
                return page;
            }

            public Class getPageIdentity() {
                return page.getClass();
            }
        };
    }

    public boolean linksTo(Page page) {
        return page.getClass() == this.pageLink.getPageIdentity();
    }

    public void onClick() {
        this.setResponsePage(this.pageLink.getPage());
    }
}

