/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.ILinkListener;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.version.undo.Change;

public abstract class Link
extends AbstractLink
implements ILinkListener {
    private static final long serialVersionUID = 1L;
    private Component anchor;
    private boolean autoEnable = false;
    private PopupSettings popupSettings = null;

    public Link(String id) {
        super(id);
    }

    public Link(String id, IModel object) {
        super(id, object);
    }

    public Component getAnchor() {
        return this.anchor;
    }

    public final boolean getAutoEnable() {
        return this.autoEnable;
    }

    public PopupSettings getPopupSettings() {
        return this.popupSettings;
    }

    public boolean isEnabled() {
        if (this.getAutoEnable()) {
            return !this.linksTo(this.getPage());
        }
        return super.isEnabled();
    }

    protected boolean getStatelessHint() {
        return false;
    }

    public abstract void onClick();

    public final void onLinkClicked() {
        if (this.popupSettings != null) {
            RequestCycle.get().getRequest().getRequestParameters().setPageMapName(this.popupSettings.getPageMap(this).getName());
        }
        this.onClick();
    }

    public Link setAnchor(Component anchor) {
        this.addStateChange(new AnchorChange(this.anchor));
        this.anchor = anchor;
        return this;
    }

    public final Link setAutoEnable(boolean autoEnable) {
        this.autoEnable = autoEnable;
        return this;
    }

    public final Link setPopupSettings(PopupSettings popupSettings) {
        this.popupSettings = popupSettings;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CharSequence appendAnchor(ComponentTag tag, CharSequence url) {
        if (url == null) return url;
        Component anchor = this.getAnchor();
        if (anchor != null) {
            if (((Object)url).toString().indexOf(35) != -1) return url;
            String id = anchor.getOutputMarkupId() ? anchor.getMarkupId() : anchor.getMarkupAttributes().getString("id");
            if (id == null) throw new WicketRuntimeException("an achor component was set on " + this + " but it neither has outputMarkupId set to true " + "nor has a id set explicitly");
            return url + "#" + anchor.getMarkupId();
        }
        if (!tag.getName().equalsIgnoreCase("a")) return url;
        if (((Object)url).toString().indexOf(35) != -1) return url;
        String href = tag.getAttributes().getString("href");
        if (href == null) return url;
        if (href.length() <= 1) return url;
        if (href.charAt(0) != '#') return url;
        return url + href;
    }

    protected CharSequence getOnClickScript(CharSequence url) {
        return this.getOnClickScript(((Object)url).toString());
    }

    protected String getOnClickScript(String url) {
        return null;
    }

    protected CharSequence getURL() {
        return this.urlFor(ILinkListener.INTERFACE);
    }

    protected boolean linksTo(Page page) {
        return false;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.popupSettings != null) {
            RequestCycle.get().setUrlForNewWindowEncoding();
        }
        CharSequence url = this.getURL();
        url = this.appendAnchor(tag, url);
        if (!this.isLinkEnabled()) {
            this.disableLink(tag);
        } else {
            IPageMap popupPageMap;
            CharSequence onClickJavaScript;
            if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
                tag.put("href", Strings.replaceAll(url, "&", "&amp;"));
                if (this.popupSettings != null) {
                    tag.put("onclick", this.popupSettings.getPopupJavaScript());
                }
            } else if (tag.getName().equalsIgnoreCase("script") || tag.getName().equalsIgnoreCase("style")) {
                tag.put("src", Strings.replaceAll(url, "&", "&amp;"));
            } else if (this.popupSettings != null) {
                this.popupSettings.setTarget("'" + url + "'");
                String popupScript = this.popupSettings.getPopupJavaScript();
                tag.put("onclick", popupScript);
            } else {
                tag.put("onclick", "var win = this.ownerDocument.defaultView || this.ownerDocument.parentWindow; if (win == window) { window.location.href='" + url + "'; } ;return false");
            }
            if ((onClickJavaScript = this.getOnClickScript(url)) != null) {
                tag.put("onclick", onClickJavaScript);
            }
            if (this.popupSettings != null && (popupPageMap = this.popupSettings.getPageMap(this)) != null && popupPageMap.getName() != null) {
                tag.put("target", popupPageMap.getName());
            }
        }
    }

    private final class AnchorChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final Component anchor;

        public AnchorChange(Component anchor) {
            this.anchor = anchor;
        }

        public final void undo() {
            Link.this.anchor = this.anchor;
        }
    }
}

