/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.util.collections.ReadOnlyIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enclosure
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)Enclosure.class);
    private Component childComponent;
    private final CharSequence childId;
    private transient Map originalVisibilityStatus;
    static /* synthetic */ Class class$org$apache$wicket$markup$html$border$Border;

    public Enclosure(String id, CharSequence childId) {
        super(id);
        this.childId = childId;
    }

    public boolean isTransparentResolver() {
        return true;
    }

    public Component getChildComponent() {
        if (this.childComponent == null) {
            MarkupContainer parent = this.getEnclosureParent();
            if (this.childId == null) {
                throw new MarkupException("You most likely forgot to register the EnclosureHandler with the MarkupParserFactory");
            }
            Component child = parent.get(((Object)this.childId).toString());
            if (child == null) {
                throw new MarkupException("Didn't find child component of <wicket:enclosure> with id='" + this.childId + "'. Component: " + this.toString());
            }
            this.childComponent = child;
        }
        return this.childComponent;
    }

    private MarkupContainer getEnclosureParent() {
        MarkupContainer parent = this.getParent();
        while (parent != null) {
            if (parent.isTransparentResolver()) {
                parent = parent.getParent();
                continue;
            }
            if (!(parent instanceof Border.BorderBodyContainer)) break;
            parent = ((Border.BorderBodyContainer)parent).findParent(class$org$apache$wicket$markup$html$border$Border == null ? Enclosure.class$("org.apache.wicket.markup.html.border.Border") : class$org$apache$wicket$markup$html$border$Border);
        }
        if (parent == null) {
            throw new WicketRuntimeException("Unable to find parent component which is not a transparent resolver");
        }
        return parent;
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        Component controller = this.getChildComponent();
        if (controller == this) {
            throw new WicketRuntimeException("Programming error: childComponent == enclose component; endless loop");
        }
        this.setVisible(controller.determineVisibility());
        this.originalVisibilityStatus = new HashMap();
        DirectChildTagIterator it = new DirectChildTagIterator(markupStream, openTag);
        MarkupContainer controllerParent = this.getEnclosureParent();
        while (it.hasNext()) {
            ComponentTag t = (ComponentTag)it.next();
            Component child = controllerParent.get(t.getId());
            if (child == null) continue;
            this.originalVisibilityStatus.put(child, child.isVisibilityAllowed());
            child.setVisibilityAllowed(this.isVisible());
        }
        it.rewind();
        if (this.isVisible()) {
            super.onComponentTagBody(markupStream, openTag);
        } else {
            markupStream.skipToMatchingCloseTag(openTag);
        }
    }

    protected void onDetach() {
        if (this.originalVisibilityStatus != null) {
            Iterator it = this.originalVisibilityStatus.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Component c = (Component)entry.getKey();
                boolean vis = (Boolean)entry.getValue();
                c.setVisibilityAllowed(vis);
            }
            this.originalVisibilityStatus = null;
        }
        super.onDetach();
    }

    private static class DirectChildTagIterator
    extends ReadOnlyIterator {
        private final MarkupStream markupStream;
        private final ComponentTag parent;
        private ComponentTag next = null;
        private final int originalIndex;

        public DirectChildTagIterator(MarkupStream markupStream, ComponentTag parent) {
            this.markupStream = markupStream;
            this.parent = parent;
            this.originalIndex = markupStream.getCurrentIndex();
            this.findNext();
        }

        public void rewind() {
            this.markupStream.setCurrentIndex(this.originalIndex);
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            ComponentTag ret = this.next;
            this.findNext();
            return ret;
        }

        private void findNext() {
            MarkupElement cursor;
            ComponentTag tag = this.next;
            this.next = null;
            if (tag != null && tag.isOpenClose()) {
                tag = null;
            }
            while (this.markupStream.hasMore() && !(cursor = this.markupStream.next()).closes(this.parent)) {
                if (tag != null && cursor.closes(tag)) {
                    tag = null;
                    continue;
                }
                if (tag != null || !(cursor instanceof ComponentTag)) continue;
                this.next = (ComponentTag)cursor;
                break;
            }
        }
    }
}

