/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.RequestContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converters.BooleanConverter;
import org.apache.wicket.util.string.StringValueConversionException;
import org.apache.wicket.util.string.Strings;

public class CheckBox
extends FormComponent
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;

    public CheckBox(String id) {
        super(id);
    }

    public CheckBox(String id, IModel model) {
        super(id, model);
    }

    public void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged(this.getModelObject());
    }

    protected void onSelectionChanged(Object newSelection) {
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }

    public IConverter getConverter(Class type) {
        return BooleanConverter.INSTANCE;
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "checkbox");
        String value = this.getValue();
        if (value != null) {
            try {
                if (Strings.isTrue(value)) {
                    tag.put("checked", "checked");
                } else {
                    tag.remove("checked");
                }
            }
            catch (StringValueConversionException e) {
                throw new WicketRuntimeException("Invalid boolean value \"" + value + "\"", e);
            }
        }
        if (this.wantOnSelectionChangedNotifications()) {
            CharSequence url = this.urlFor(IOnChangeListener.INTERFACE);
            Form form = (Form)this.findParent(Form.class);
            if (form != null) {
                RequestContext rc = RequestContext.get();
                if (rc.isPortletRequest()) {
                    url = ((PortletRequestContext)rc).getLastEncodedPath();
                }
                tag.put("onclick", form.getJsForInterfaceUrl(url));
            } else {
                tag.put("onclick", "window.location.href='" + url + (((Object)url).toString().indexOf(63) > -1 ? "&amp;" : "?") + this.getInputName() + "=' + this.checked;");
            }
        }
        super.onComponentTag(tag);
    }

    protected final boolean supportsPersistence() {
        return true;
    }

    protected Object convertValue(String[] value) {
        String tmp = value != null && value.length > 0 ? value[0] : null;
        try {
            return Strings.toBoolean(tmp);
        }
        catch (StringValueConversionException e) {
            throw new ConversionException("Invalid boolean input value posted \"" + this.getInput() + "\"", e).setTargetType(Boolean.class);
        }
    }
}

