/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.Strings;

public final class PageView
extends Panel {
    private static final long serialVersionUID = 1L;

    public PageView(String id, Page page) {
        super(id);
        ArrayList data = new ArrayList();
        this.add(new Label("info", page == null ? "[Stateless Page]" : page.toString()));
        data.clear();
        if (page != null) {
            data.addAll(this.getComponentData(page));
        }
        Collections.sort(data, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ComponentData)o1).path.compareTo(((ComponentData)o2).path);
            }
        });
        this.add(new ListView("components", data){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem listItem) {
                ComponentData componentData = (ComponentData)listItem.getModelObject();
                listItem.add(new Label("row", Integer.toString(listItem.getIndex() + 1)));
                listItem.add(new Label("path", componentData.path));
                listItem.add(new Label("size", Bytes.bytes(componentData.size).toString()));
                listItem.add(new Label("type", componentData.type));
                listItem.add(new Label("model", componentData.value));
            }
        });
    }

    private List getComponentData(Page page) {
        final ArrayList data = new ArrayList();
        page.visitChildren(new Component.IVisitor(){

            public Object component(Component component) {
                if (!component.getPath().startsWith(PageView.this.getPath())) {
                    String name = component.getClass().getName();
                    if (name.indexOf("$") > 0) {
                        name = component.getClass().getSuperclass().getName();
                    }
                    name = Strings.lastPathComponent(name, ':');
                    ComponentData componentData = new ComponentData(component.getPageRelativePath(), name, component.getSizeInBytes());
                    try {
                        componentData.value = component.getModelObjectAsString();
                    }
                    catch (Exception e) {
                        componentData.value = e.getMessage();
                    }
                    data.add(componentData);
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
        return data;
    }

    private static class ComponentData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        public final String path;
        public final String type;
        public String value;
        public final long size;

        ComponentData(String path, String type, long size) {
            this.path = path;
            this.type = type;
            this.size = size;
        }
    }
}

