/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageMap;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.util.lang.Objects;

public abstract class PageMap
implements IClusterable,
IPageMap {
    public static final String DEFAULT_NAME = null;
    private static final long serialVersionUID = 1L;
    private String interceptContinuationURL;
    private final String name;
    private int pageId = 0;
    private MetaDataEntry[] metaData;

    public static IPageMap forName(String pageMapName) {
        Session session = Session.get();
        return session != null ? session.pageMapForName(pageMapName, true) : null;
    }

    public PageMap(String name) {
        if ("".equals(name)) {
            throw new IllegalStateException("Empty string name for pagemaps is not allowed");
        }
        this.name = name;
    }

    public final String attributeForId(int id) {
        return this.attributePrefix() + id;
    }

    public void clear() {
        this.visitEntries(new IVisitor(){

            public void entry(IPageMapEntry entry) {
                PageMap.this.removeEntry(entry);
            }
        });
    }

    public final boolean continueToOriginalDestination() {
        RequestCycle cycle = RequestCycle.get();
        if (this.interceptContinuationURL != null) {
            cycle.setRequestTarget(new RedirectRequestTarget(this.interceptContinuationURL));
            this.interceptContinuationURL = null;
            this.dirty();
            return true;
        }
        return false;
    }

    public abstract Page get(int var1, int var2);

    public final IPageMapEntry getEntry(int id) {
        return (IPageMapEntry)Session.get().getAttribute(this.attributeForId(id));
    }

    public final String getName() {
        return this.name;
    }

    public final Session getSession() {
        return Session.get();
    }

    public final long getSizeInBytes() {
        long size = Objects.sizeof(this);
        Iterator it = this.getEntries().iterator();
        while (it.hasNext()) {
            IPageMapEntry entry = (IPageMapEntry)it.next();
            if (entry instanceof Page) {
                size += ((Page)entry).getSizeInBytes();
                continue;
            }
            size += Objects.sizeof(entry);
        }
        return size;
    }

    public final boolean isDefault() {
        return this.name == DEFAULT_NAME;
    }

    public final int nextId() {
        this.dirty();
        return this.pageId++;
    }

    public abstract void put(Page var1);

    public final void redirectToInterceptPage(Class pageClazz) {
        RequestCycle cycle = RequestCycle.get();
        this.setUpRedirect(cycle);
        cycle.setResponsePage(pageClazz);
    }

    public final void redirectToInterceptPage(Page page) {
        RequestCycle cycle = RequestCycle.get();
        this.setUpRedirect(cycle);
        cycle.setResponsePage(page);
    }

    private void setUpRedirect(RequestCycle cycle) {
        Session session = Session.get();
        if (session.isTemporary()) {
            session.bind();
        }
        this.interceptContinuationURL = cycle.getRequest() instanceof WebRequest && ((WebRequest)cycle.getRequest()).isAjax() ? ((Object)cycle.urlFor(cycle.getRequest().getPage())).toString() : "/" + cycle.getRequest().getURL();
        this.dirty();
        cycle.setRedirect(true);
    }

    public final void remove() {
        this.clear();
        Session.get().removePageMap(this);
    }

    public final void remove(Page page) {
        this.removeEntry(page.getPageMapEntry());
        Session.get().untouch(page);
    }

    public abstract void removeEntry(IPageMapEntry var1);

    public String toString() {
        return "[PageMap name=" + this.name + "]";
    }

    private final List getEntries() {
        Session session = Session.get();
        List attributes = session.getAttributeNames();
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            if (!attribute.startsWith(this.attributePrefix())) continue;
            list.add(session.getAttribute(attribute));
        }
        return list;
    }

    protected final void dirty() {
        Session.get().dirtyPageMap(this);
    }

    protected final void visitEntries(IVisitor visitor) {
        Session session = Session.get();
        List attributes = session.getAttributeNames();
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            if (!attribute.startsWith(this.attributePrefix())) continue;
            visitor.entry((IPageMapEntry)session.getAttribute(attribute));
        }
    }

    public final void setMetaData(MetaDataKey key, Serializable object) {
        this.metaData = key.set(this.metaData, object);
    }

    public final Serializable getMetaData(MetaDataKey key) {
        return (Serializable)key.get(this.metaData);
    }

    final String attributePrefix() {
        return "p:" + this.name + ":";
    }

    static interface IVisitor {
        public void entry(IPageMapEntry var1);
    }
}

