/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.model.IModel;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.settings.IResourceSettings;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.interpolator.PropertyVariableInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localizer {
    private static final Logger logger = LoggerFactory.getLogger((Class)Localizer.class);
    private static final String NULL_VALUE = "<null-value>";
    private Map cache = this.newCache();
    private final ClassMetaDatabase metaDatabase = new ClassMetaDatabase();

    public final void clearCache() {
        if (this.cache != null) {
            this.cache = this.newCache();
        }
    }

    public String getString(String key, Component component) throws MissingResourceException {
        return this.getString(key, component, null, null);
    }

    public String getString(String key, Component component, IModel model) throws MissingResourceException {
        return this.getString(key, component, model, null);
    }

    public String getString(String key, Component component, String defaultValue) throws MissingResourceException {
        return this.getString(key, component, null, defaultValue);
    }

    public String getString(String key, Component component, IModel model, Locale locale, String style, String defaultValue) throws MissingResourceException {
        return this.getString(key, component, model, defaultValue);
    }

    public String getString(String key, Component component, IModel model, String defaultValue) throws MissingResourceException {
        IResourceSettings resourceSettings = Application.get().getResourceSettings();
        boolean addedToPage = false;
        if (component != null) {
            if (component instanceof Page || null != component.findParent(Page.class)) {
                addedToPage = true;
            }
            if (!addedToPage) {
                logger.warn("Tried to retrieve a localized string for a component that has not yet been added to the page. This can sometimes lead to an invalid or no localized resource returned. Make sure you are not calling Component#getString() inside your Component's constructor. Offending component: {}", (Object)component);
            }
        }
        String cacheKey = null;
        String string = null;
        if (this.cache != null && addedToPage) {
            cacheKey = this.getCacheKey(key, component);
        }
        if (cacheKey != null && this.cache.containsKey(cacheKey)) {
            string = this.getFromCache(cacheKey);
        } else {
            IStringResourceLoader loader;
            Iterator iter = resourceSettings.getStringResourceLoaders().iterator();
            while (iter.hasNext() && (string = (loader = (IStringResourceLoader)iter.next()).loadStringResource(component, key)) == null) {
            }
            if (cacheKey != null) {
                this.putIntoCache(cacheKey, string);
            }
        }
        if (string == null && defaultValue != null && resourceSettings.getUseDefaultOnMissingResource()) {
            string = defaultValue;
        }
        if (string != null) {
            return this.substitutePropertyExpressions(component, string, model);
        }
        if (resourceSettings.getThrowExceptionOnMissingResource()) {
            AppendingStringBuffer message = new AppendingStringBuffer("Unable to find resource: " + key);
            if (component != null) {
                message.append(" for component: ");
                message.append(component.getPageRelativePath());
                message.append(" [class=").append(component.getClass().getName()).append("]");
            }
            throw new MissingResourceException(message.toString(), component != null ? component.getClass().getName() : "", key);
        }
        return "[Warning: String resource for '" + key + "' not found]";
    }

    protected void putIntoCache(String cacheKey, String string) {
        if (this.cache == null) {
            return;
        }
        if (string == null) {
            this.cache.put(cacheKey, NULL_VALUE);
        } else {
            this.cache.put(cacheKey, string);
        }
    }

    protected String getFromCache(String cacheKey) {
        if (this.cache == null) {
            return null;
        }
        String value = (String)this.cache.get(cacheKey);
        if (value == NULL_VALUE) {
            return null;
        }
        return value;
    }

    protected String getCacheKey(String key, Component component) {
        String cacheKey = key;
        if (component != null) {
            AppendingStringBuffer buffer = new AppendingStringBuffer(200);
            buffer.append(key);
            for (Component cursor = component; cursor != null; cursor = cursor.getParent()) {
                buffer.append("-").append(this.metaDatabase.id(cursor.getClass()));
                if (cursor instanceof Page) break;
                if (cursor.getParent() == null || cursor.getParent() instanceof AbstractRepeater) continue;
                buffer.append(":").append(cursor.getId());
            }
            buffer.append("-").append(component.getLocale());
            buffer.append("-").append(component.getStyle());
            cacheKey = buffer.toString();
        }
        return cacheKey;
    }

    public String substitutePropertyExpressions(Component component, String string, IModel model) {
        if (string != null && model != null) {
            return PropertyVariableInterpolator.interpolate(string, model.getObject());
        }
        return string;
    }

    public final void setEnableCache(boolean value) {
        if (!value) {
            this.cache = null;
        } else if (this.cache == null) {
            this.cache = this.newCache();
        }
    }

    protected Map newCache() {
        return new ConcurrentHashMap();
    }

    private static class ClassMetaDatabase {
        private final Map nameToId = new HashMap();
        private long nameCounter = 0L;

        private ClassMetaDatabase() {
        }

        public synchronized long id(Class clazz) {
            String name = clazz.getName();
            Long id = (Long)this.nameToId.get(name);
            if (id == null) {
                id = new Long(this.nameCounter);
                this.nameToId.put(name, id);
                ++this.nameCounter;
            }
            return id;
        }
    }
}

