/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.TextTemplate;
import org.apache.wicket.util.time.Time;

public abstract class TextTemplateDecorator
extends TextTemplate {
    private static final long serialVersionUID = 1L;
    protected final TextTemplate decorated;

    public TextTemplateDecorator(TextTemplate textTemplate) {
        if (textTemplate == null) {
            throw new IllegalArgumentException("argument textTemplate must be not null");
        }
        this.decorated = textTemplate;
    }

    public String asString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getBeforeTemplateContents());
        b.append(this.decorated.asString());
        b.append(this.getAfterTemplateContents());
        return b.toString();
    }

    public String asString(Map variables) {
        StringBuffer b = new StringBuffer();
        b.append(this.getBeforeTemplateContents());
        b.append(this.decorated.asString(variables));
        b.append(this.getAfterTemplateContents());
        return b.toString();
    }

    public abstract String getBeforeTemplateContents();

    public abstract String getAfterTemplateContents();

    public void close() throws IOException {
        this.decorated.close();
    }

    public boolean equals(Object obj) {
        return this.decorated.equals(obj);
    }

    public String getContentType() {
        return this.decorated.getContentType();
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return this.decorated.getInputStream();
    }

    public Locale getLocale() {
        return this.decorated.getLocale();
    }

    public int hashCode() {
        return this.decorated.hashCode();
    }

    public Time lastModifiedTime() {
        return this.decorated.lastModifiedTime();
    }

    public long length() {
        return Strings.lengthInBytes(this.getString(), this.getCharset());
    }

    public void setCharset(Charset charset) {
        this.decorated.setCharset(charset);
    }

    public void setLastModified(Time lastModified) {
        this.decorated.setLastModified(lastModified);
    }

    public void setLocale(Locale locale) {
        this.decorated.setLocale(locale);
    }

    public String getString() {
        return this.decorated.getString();
    }

    public String toString() {
        return this.decorated.toString();
    }
}

