/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public abstract class AbstractStringResourceStream
extends AbstractResourceStream {
    private static final long serialVersionUID = 1L;
    private final String contentType;
    private Time lastModified = null;

    public AbstractStringResourceStream() {
        this("text");
    }

    public AbstractStringResourceStream(String contentType) {
        this.contentType = contentType;
    }

    public void close() throws IOException {
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        byte[] bytes;
        if (this.getCharset() != null) {
            try {
                bytes = this.getString().getBytes(this.getCharset().name());
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceStreamNotFoundException("Could not encode resource", e);
            }
        } else {
            bytes = this.getString().getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }

    public Time lastModifiedTime() {
        return this.lastModified;
    }

    public void setLastModified(Time lastModified) {
        this.lastModified = lastModified;
    }

    protected abstract String getString();
}

