/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converters;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.wicket.util.convert.converters.AbstractDecimalConverter;

public class BigDecimalConverter
extends AbstractDecimalConverter {
    private static final long serialVersionUID = 1L;

    protected Class getTargetType() {
        return BigDecimal.class;
    }

    public Object convertToObject(String value, Locale locale) {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        Number number = this.parse(value, -1.7976931348623157E308, Double.MAX_VALUE, locale);
        if (number instanceof BigDecimal) {
            return number;
        }
        if (number instanceof Double) {
            return new BigDecimal(number.doubleValue());
        }
        if (number instanceof Long) {
            return new BigDecimal(Long.toString(number.longValue()));
        }
        if (number instanceof Float) {
            return new BigDecimal(number.floatValue());
        }
        if (number instanceof Integer) {
            return new BigDecimal(Integer.toString(number.intValue()));
        }
        return new BigDecimal(value);
    }
}

