/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.wicket.util.collections.MicroMap;

public final class MicroMap
implements Map,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_ENTRIES = 1;
    private Object key;
    private Object value;

    public MicroMap() {
    }

    public MicroMap(Object key, Object value) {
        this.put(key, value);
    }

    public boolean isFull() {
        return this.size() == 1;
    }

    public int size() {
        return this.key != null ? 1 : 0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return key.equals(this.key);
    }

    public boolean containsValue(Object value) {
        return value.equals(this.value);
    }

    public Object get(Object key) {
        if (key.equals(this.key)) {
            return this.value;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        if (key.equals(this.key)) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }
        if (this.size() < 1) {
            this.key = key;
            this.value = value;
            return null;
        }
        throw new IllegalStateException("Map full");
    }

    public Object remove(Object key) {
        if (key.equals(this.key)) {
            Object oldValue = this.value;
            this.key = null;
            this.value = null;
            return oldValue;
        }
        return null;
    }

    public void putAll(Map map) {
        if (map.size() > 1) {
            throw new IllegalStateException("Map full.  Cannot add " + map.size() + " entries");
        }
        Map.Entry e = map.entrySet().iterator().next();
        this.put(e.getKey(), e.getValue());
    }

    public void clear() {
        this.key = null;
        this.value = null;
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new Iterator(this){
                    int index;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean hasNext() {
                        return this.index < 1.access$000(this.this$1).size();
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.index;
                        return MicroMap.access$100(1.access$000(this.this$1));
                    }

                    public void remove() {
                        1.access$000(this.this$1).clear();
                    }
                };
            }

            public int size() {
                return MicroMap.this.size();
            }

            static /* synthetic */ MicroMap access$000(1 x0) {
                return x0.MicroMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractList(){

            public Object get(int index) {
                if (index > this.size() - 1) {
                    throw new IndexOutOfBoundsException();
                }
                return MicroMap.this.value;
            }

            public int size() {
                return MicroMap.this.size();
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new Iterator(this){
                    int index;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.index = 0;
                    }

                    public boolean hasNext() {
                        return this.index < 4.access$300(this.this$1).size();
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.index;
                        return new Map.Entry(this){
                            private final /* synthetic */ 5 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public Object getKey() {
                                return MicroMap.access$100(4.access$300(5.access$400(this.this$2)));
                            }

                            public Object getValue() {
                                return MicroMap.access$200(4.access$300(5.access$400(this.this$2)));
                            }

                            public Object setValue(Object value) {
                                Object oldValue = MicroMap.access$200(4.access$300(5.access$400(this.this$2)));
                                MicroMap.access$202(4.access$300(5.access$400(this.this$2)), value);
                                return oldValue;
                            }
                        };
                    }

                    public void remove() {
                        this.this$1.clear();
                    }

                    static /* synthetic */ 4 access$400(5 x0) {
                        return x0.this$1;
                    }
                };
            }

            public int size() {
                return MicroMap.this.size();
            }

            static /* synthetic */ MicroMap access$300(4 x0) {
                return x0.MicroMap.this;
            }
        };
    }

    static /* synthetic */ Object access$100(MicroMap x0) {
        return x0.key;
    }

    static /* synthetic */ Object access$202(MicroMap x0, Object x1) {
        x0.value = x1;
        return x0.value;
    }
}

