/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.component.listener;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.listener.AbstractListenerInterfaceRequestTarget;

public class BehaviorRequestTarget
extends AbstractListenerInterfaceRequestTarget {
    public BehaviorRequestTarget(Page page, Component component, RequestListenerInterface listener) {
        this(page, component, listener, null);
    }

    public BehaviorRequestTarget(Page page, Component component, RequestListenerInterface listener, RequestParameters requestParameters) {
        super(page, component, listener, requestParameters);
    }

    public final void processEvents(RequestCycle requestCycle) {
        this.onProcessEvents(requestCycle);
        Component component = this.getTarget();
        String id = this.getRequestParameters().getBehaviorId();
        if (id == null) {
            throw new IllegalStateException("Parameter behaviorId was not provided: unable to locate listener. Component: " + component.toString());
        }
        int idAsInt = Integer.parseInt(id);
        List behaviors = component.getBehaviorsRawList();
        IBehaviorListener behaviorListener = null;
        if (behaviors.size() > idAsInt) {
            behaviorListener = (IBehaviorListener)behaviors.get(idAsInt);
        }
        if (behaviorListener == null) {
            throw new IllegalStateException("No behavior listener found with behaviorId " + id + "; Component: " + component.toString());
        }
        behaviorListener.onRequest();
    }
}

