/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.Component;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.util.lang.PropertyResolver;

public class ComponentPropertyModel
extends AbstractReadOnlyModel
implements IComponentAssignedModel {
    private static final long serialVersionUID = 1L;
    private final String propertyName;

    public ComponentPropertyModel(String propertyName) {
        this.propertyName = propertyName;
    }

    public Object getObject() {
        throw new IllegalStateException("Wrapper should have been called");
    }

    public IWrapModel wrapOnAssignment(Component component) {
        return new AssignmentWrapper(component, this.propertyName);
    }

    private class AssignmentWrapper
    extends AbstractReadOnlyModel
    implements IWrapModel {
        private static final long serialVersionUID = 1L;
        private final Component component;
        private final String propertyName;

        AssignmentWrapper(Component component, String propertyName) {
            this.component = component;
            this.propertyName = propertyName;
        }

        public IModel getWrappedModel() {
            return ComponentPropertyModel.this;
        }

        protected String propertyExpression() {
            return this.propertyName;
        }

        public Object getObject() {
            return PropertyResolver.getValue(this.propertyName, this.component.getParent().getInnermostModel().getObject());
        }

        public void detach() {
            super.detach();
            ComponentPropertyModel.this.detach();
        }
    }
}

