/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainerWithAssociatedMarkup;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.version.undo.Change;

public class Fragment
extends WebMarkupContainerWithAssociatedMarkup {
    private static final long serialVersionUID = 1L;
    private String markupId;
    private final MarkupContainer markupProvider;

    public Fragment(String id, String markupId) {
        this(id, markupId, null, null);
    }

    public Fragment(String id, String markupId, IModel model) {
        this(id, markupId, null, model);
    }

    public Fragment(String id, String markupId, MarkupContainer markupProvider) {
        this(id, markupId, markupProvider, null);
    }

    public Fragment(String id, String markupId, MarkupContainer markupProvider, IModel model) {
        super(id, model);
        if (markupId == null) {
            throw new IllegalArgumentException("markupId cannot be null");
        }
        this.markupId = markupId;
        this.markupProvider = markupProvider;
    }

    public final void setMarkupTagReferenceId(String markupId) {
        if (markupId == null) {
            throw new IllegalArgumentException("markupId cannot be null");
        }
        if (!Objects.equal(this.markupId, markupId)) {
            this.addStateChange(new Change(){
                private static final long serialVersionUID = 1L;
                private final String oldMarkupId;
                {
                    this.oldMarkupId = Fragment.this.markupId;
                }

                public void undo() {
                    Fragment.this.markupId = this.oldMarkupId;
                }
            });
        }
        this.markupId = markupId;
    }

    protected void onComponentTag(ComponentTag tag) {
        if (tag.isOpenClose()) {
            tag.setType(XmlTag.OPEN);
        }
        super.onComponentTag(tag);
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        MarkupStream providerMarkupStream;
        if (((ComponentTag)markupStream.get(markupStream.getCurrentIndex() - 1)).isOpen()) {
            markupStream.skipRawMarkup();
        }
        if ((providerMarkupStream = this.chooseMarkupStream(markupStream)) == null) {
            throw new MarkupNotFoundException("Fragment: No markup stream found for providing markup container " + this.markupProvider.toString() + ". Fragment: " + this.toString());
        }
        this.renderFragment(providerMarkupStream, openTag);
    }

    protected MarkupStream chooseMarkupStream(MarkupStream markupStream) {
        MarkupStream stream = null;
        if (this.markupProvider == null) {
            stream = markupStream;
        } else {
            stream = this.markupProvider.getAssociatedMarkupStream(false);
            if (stream == null) {
                stream = this.markupProvider.getMarkupStream();
            }
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFragment(MarkupStream providerMarkupStream, ComponentTag openTag) {
        int currentIndex = providerMarkupStream.getCurrentIndex();
        int index = providerMarkupStream.findComponentIndex(null, this.markupId);
        if (index == -1) {
            throw new MarkupException("Markup of component class `" + providerMarkupStream.getContainerClass().getName() + "` does not contain a fragment with wicket:id `" + this.markupId + "`. Context: " + this.toString());
        }
        providerMarkupStream.setCurrentIndex(index);
        try {
            ComponentTag fragmentOpenTag = providerMarkupStream.getTag();
            if (!fragmentOpenTag.isOpenClose()) {
                providerMarkupStream.next();
                super.onComponentTagBody(providerMarkupStream, fragmentOpenTag);
            }
        }
        finally {
            providerMarkupStream.setCurrentIndex(currentIndex);
        }
    }

    public MarkupStream findComponentIndex(String path) {
        MarkupStream markupStream = this.getAssociatedMarkupStream(true);
        int index = markupStream.findComponentIndex(this.markupId, path);
        if (index == -1) {
            throw new MarkupException("Markup of component class `" + markupStream.getContainerClass().getName() + "` does not contain a fragment with wicket:id `" + this.markupId + "`. Context: " + this.toString());
        }
        markupStream.setCurrentIndex(index);
        return markupStream;
    }

    public boolean hasAssociatedMarkup() {
        return true;
    }

    public MarkupStream getAssociatedMarkupStream(boolean throwException) {
        MarkupStream stream = null;
        if (this.markupProvider != null && (stream = this.markupProvider.getAssociatedMarkupStream(false)) == null) {
            stream = this.markupProvider.getMarkupStream();
        }
        if (stream == null) {
            stream = super.getAssociatedMarkupStream(false);
        }
        if (stream == null && this.getParent() != null) {
            stream = this.getParent().getAssociatedMarkupStream(false);
        }
        if (stream == null && throwException) {
            super.getAssociatedMarkupStream(true);
        }
        return stream;
    }

    public final MarkupContainer getMarkupProvider() {
        return this.markupProvider;
    }
}

