/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.navigation.paging;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.navigation.paging.IPageable;

public class PagingNavigationLink
extends Link {
    private static final long serialVersionUID = 1L;
    protected final IPageable pageable;
    private final int pageNumber;

    public PagingNavigationLink(String id, IPageable pageable, int pageNumber) {
        super(id);
        this.setAutoEnable(true);
        this.pageNumber = pageNumber;
        this.pageable = pageable;
    }

    public void onClick() {
        this.pageable.setCurrentPage(this.getPageNumber());
    }

    public final int getPageNumber() {
        return this.cullPageNumber(this.pageNumber);
    }

    protected int cullPageNumber(int pageNumber) {
        int idx = pageNumber;
        if (idx < 0) {
            idx = this.pageable.getPageCount() + idx;
        }
        if (idx > this.pageable.getPageCount() - 1) {
            idx = this.pageable.getPageCount() - 1;
        }
        if (idx < 0) {
            idx = 0;
        }
        return idx;
    }

    public final boolean isFirst() {
        return this.getPageNumber() == 0;
    }

    public final boolean isLast() {
        return this.getPageNumber() == this.pageable.getPageCount() - 1;
    }

    public final boolean linksTo(Page page) {
        return this.getPageNumber() == this.pageable.getCurrentPage();
    }
}

