/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmitListener;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.IFormVisitorParticipant;
import org.apache.wicket.markup.html.form.persistence.CookieValuePersister;
import org.apache.wicket.markup.html.form.persistence.IValuePersister;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WicketURLDecoder;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.listener.IListenerInterfaceRequestTarget;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.upload.FileUploadBase;
import org.apache.wicket.util.upload.FileUploadException;
import org.apache.wicket.util.value.ValueMap;
import org.apache.wicket.validation.IValidatorAddListener;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Form
extends WebMarkupContainer
implements IFormSubmitListener {
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private static final short FLAG_SUBMITTED = 256;
    private static final Logger log = LoggerFactory.getLogger((Class)Form.class);
    private static final long serialVersionUID = 1L;
    private static final String UPLOAD_FAILED_RESOURCE_KEY = "uploadFailed";
    private static final String UPLOAD_TOO_LARGE_RESOURCE_KEY = "uploadTooLarge";
    private IFormSubmittingComponent defaultSubmittingComponent;
    private Object formValidators = null;
    private String javascriptId;
    private Bytes maxSize = null;
    private boolean multiPart = false;

    public Form(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    public Form(String id, IModel model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    public void add(IFormValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("Argument `validator` cannot be null");
        }
        this.formValidators_add(validator);
        if (validator instanceof IValidatorAddListener) {
            ((IValidatorAddListener)((Object)validator)).onAdded(this);
        }
    }

    public void remove(IFormValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("Argument `validator` cannot be null");
        }
        IFormValidator removed = this.formValidators_remove(validator);
        if (removed == null) {
            throw new IllegalStateException("Tried to remove form validator that was not previously added. Make sure your validator's equals() implementation is sufficient");
        }
        this.addStateChange(new FormValidatorRemovedChange(removed));
    }

    private final int formValidators_indexOf(IFormValidator validator) {
        if (this.formValidators != null) {
            if (this.formValidators instanceof IFormValidator) {
                IFormValidator v = (IFormValidator)this.formValidators;
                if (v == validator || v.equals(validator)) {
                    return 0;
                }
            } else {
                IFormValidator[] validators = (IFormValidator[])this.formValidators;
                for (int i = 0; i < validators.length; ++i) {
                    IFormValidator v = validators[i];
                    if (v != validator && !v.equals(validator)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private final IFormValidator formValidators_remove(IFormValidator validator) {
        int index = this.formValidators_indexOf(validator);
        if (index != -1) {
            return this.formValidators_remove(index);
        }
        return null;
    }

    private final IFormValidator formValidators_remove(int index) {
        if (this.formValidators instanceof IFormValidator) {
            if (index == 0) {
                IFormValidator removed = (IFormValidator)this.formValidators;
                this.formValidators = null;
                return removed;
            }
            throw new IndexOutOfBoundsException();
        }
        IFormValidator[] validators = (IFormValidator[])this.formValidators;
        IFormValidator removed = validators[index];
        if (validators.length == 2) {
            this.formValidators = validators[1 - index];
        } else {
            IFormValidator[] newValidators = new IFormValidator[validators.length - 1];
            int j = 0;
            for (int i = 0; i < validators.length; ++i) {
                if (i == index) continue;
                newValidators[j++] = validators[i];
            }
            this.formValidators = newValidators;
        }
        return removed;
    }

    public final void clearInput() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.clearInput();
                }
            }
        });
    }

    public final void error(String error, Map args) {
        this.error((Serializable)((Object)new MapVariableInterpolator(error, args).toString()));
    }

    public final IFormSubmittingComponent findSubmittingButton() {
        IFormSubmittingComponent submittingComponent = (IFormSubmittingComponent)this.getPage().visitChildren(IFormSubmittingComponent.class, new Component.IVisitor(){

            public Object component(Component component) {
                IFormSubmittingComponent submittingComponent = (IFormSubmittingComponent)((Object)component);
                if (submittingComponent.getForm() != null && submittingComponent.getForm().getRootForm() == Form.this && (Form.this.getRequest().getParameter(submittingComponent.getInputName()) != null || Form.this.getRequest().getParameter(submittingComponent.getInputName() + ".x") != null)) {
                    if (!component.isVisible()) {
                        throw new WicketRuntimeException("Submit Button " + submittingComponent.getInputName() + " (path=" + component.getPageRelativePath() + ") is not visible");
                    }
                    return submittingComponent;
                }
                return CONTINUE_TRAVERSAL;
            }
        });
        return submittingComponent;
    }

    public final IFormSubmittingComponent getDefaultButton() {
        if (this.isRootForm()) {
            return this.defaultSubmittingComponent;
        }
        return this.getRootForm().getDefaultButton();
    }

    public final Collection getFormValidators() {
        int size = this.formValidators_size();
        ArrayList<IFormValidator> validators = null;
        if (size == 0) {
            validators = Collections.EMPTY_LIST;
        } else {
            validators = new ArrayList<IFormValidator>(size);
            for (int i = 0; i < size; ++i) {
                validators.add(this.formValidators_get(i));
            }
        }
        return Collections.unmodifiableCollection(validators);
    }

    public final CharSequence getJsForInterfaceUrl(CharSequence url) {
        Form root = this.getRootForm();
        return new AppendingStringBuffer("document.getElementById('").append(root.getHiddenFieldId()).append("').value='").append(url).append("';document.getElementById('").append(root.getJavascriptId()).append("').submit();");
    }

    public Bytes getMaxSize() {
        if (this.maxSize == null) {
            return this.getApplication().getApplicationSettings().getDefaultMaximumUploadSize();
        }
        return this.maxSize;
    }

    public Form getRootForm() {
        Form form;
        Form parent = this;
        while ((parent = (Form)(form = parent).findParent(class$org$apache$wicket$markup$html$form$Form == null ? Form.class$("org.apache.wicket.markup.html.form.Form") : class$org$apache$wicket$markup$html$form$Form)) != null) {
        }
        return form;
    }

    public String getValidatorKeyPrefix() {
        return null;
    }

    public final boolean hasError() {
        if (this.hasErrorMessage()) {
            return true;
        }
        return this.anyFormComponentError();
    }

    public boolean isRootForm() {
        return this.findParent(Form.class) == null;
    }

    public final boolean isSubmitted() {
        return this.getFlag((short)256);
    }

    public boolean isVersioned() {
        return super.isVersioned();
    }

    public final void loadPersistentFormComponentValues() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                if (formComponent.isVisibleInHierarchy() && formComponent.isPersistent()) {
                    IValuePersister persister = Form.this.getValuePersister();
                    persister.load(formComponent);
                }
            }
        });
    }

    public final void onFormSubmitted() {
        this.markFormsSubmitted();
        if (this.handleMultiPart()) {
            this.inputChanged();
            String url = this.getRequest().getParameter(this.getHiddenFieldId());
            if (!Strings.isEmpty(url)) {
                this.dispatchEvent(this.getPage(), url);
            } else {
                IFormSubmittingComponent submittingComponent = this.findSubmittingButton();
                if (submittingComponent != null && !submittingComponent.getDefaultFormProcessing()) {
                    submittingComponent.onSubmit();
                } else {
                    Form formToProcess = this;
                    if (submittingComponent != null) {
                        formToProcess = submittingComponent.getForm();
                    }
                    if (formToProcess.process()) {
                        this.delegateSubmit(submittingComponent);
                    }
                }
            }
        } else if (this.hasError()) {
            this.callOnError();
        }
    }

    public boolean process() {
        if (!(this.isEnabled() && this.isEnableAllowed() && this.isVisibleInHierarchy())) {
            return false;
        }
        Page page = this.getPage();
        this.validate();
        boolean valid = false;
        if (this.hasError()) {
            this.markFormComponentsInvalid();
            this.callOnError();
            valid = false;
        } else {
            this.markFormComponentsValid();
            this.beforeUpdateFormComponentModels();
            this.updateFormComponentModels();
            this.persistFormComponentData();
            valid = true;
        }
        final PageParameters parameters = page.getPageParameters();
        if (parameters != null) {
            this.visitFormComponents(new FormComponent.IVisitor(){

                public Object formComponent(IFormVisitorParticipant formComponent) {
                    if (formComponent instanceof FormComponent) {
                        parameters.remove(((FormComponent)formComponent).getInputName());
                    }
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
            });
            parameters.remove(this.getHiddenFieldId());
        }
        return valid;
    }

    private void callOnError() {
        this.onError();
        this.visitChildren(Form.class, new Component.IVisitor(){

            public Object component(Component component) {
                Form form = (Form)component;
                if (!(form.isEnabled() && form.isEnableAllowed() && form.isVisibleInHierarchy())) {
                    return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                }
                if (form.hasError()) {
                    form.onError();
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
    }

    private void markFormsSubmitted() {
        this.setFlag((short)256, true);
        this.visitChildren(Form.class, new Component.IVisitor(){

            public Object component(Component component) {
                Form form = (Form)component;
                if (form.isEnabled() && form.isEnableAllowed() && Form.this.isVisibleInHierarchy()) {
                    form.setFlag((short)256, true);
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    public void removePersistentFormComponentValues(final boolean disablePersistence) {
        final IValuePersister persister = this.getValuePersister();
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                if (formComponent.isVisibleInHierarchy()) {
                    persister.clear(formComponent);
                    if (formComponent.isPersistent() && disablePersistence) {
                        formComponent.setPersistent(false);
                    }
                }
            }
        });
    }

    public final void setDefaultButton(IFormSubmittingComponent submittingComponent) {
        if (this.isRootForm()) {
            this.defaultSubmittingComponent = submittingComponent;
        } else {
            this.getRootForm().setDefaultButton(submittingComponent);
        }
    }

    public void setMaxSize(Bytes maxSize) {
        this.maxSize = maxSize;
    }

    public void setMultiPart(boolean multiPart) {
        this.multiPart = multiPart;
    }

    public final Component setVersioned(final boolean isVersioned) {
        super.setVersioned(isVersioned);
        this.visitFormComponents(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                formComponent.setVersioned(isVersioned);
            }
        });
        return this;
    }

    public final void visitFormComponents(final FormComponent.IVisitor visitor) {
        this.visitChildren(FormComponent.class, new Component.IVisitor(){

            public Object component(Component component) {
                visitor.formComponent((FormComponent)component);
                return CONTINUE_TRAVERSAL;
            }
        });
        this.visitChildrenInContainingBorder(visitor);
    }

    public final void visitFormComponentsPostOrder(FormComponent.IVisitor visitor) {
        FormComponent.visitFormComponentsPostOrder(this, visitor);
        this.visitChildrenInContainingBorder(visitor);
    }

    private void visitChildrenInContainingBorder(FormComponent.IVisitor visitor) {
        if (this.getParent() instanceof Border) {
            MarkupContainer border = this.getParent();
            Iterator iter = border.iterator();
            while (iter.hasNext()) {
                Component child = (Component)iter.next();
                if (!(child instanceof FormComponent)) continue;
                visitor.formComponent((FormComponent)child);
            }
        }
    }

    private boolean anyFormComponentError() {
        Object value = this.visitChildren(new Component.IVisitor(){

            public Object component(Component component) {
                if (component.hasErrorMessage()) {
                    return STOP_TRAVERSAL;
                }
                return CONTINUE_TRAVERSAL;
            }
        });
        return value == Component.IVisitor.STOP_TRAVERSAL;
    }

    private void dispatchEvent(Page page, String url) {
        RequestParameters requestParameters;
        RequestCycle rc = RequestCycle.get();
        IRequestCycleProcessor processor = rc.getProcessor();
        IRequestTarget rt = processor.resolve(rc, requestParameters = processor.getRequestCodingStrategy().decode(new FormDispatchRequest(rc.getRequest(), url)));
        if (!(rt instanceof IListenerInterfaceRequestTarget)) {
            throw new WicketRuntimeException("Attempt to access unknown request listener interface " + requestParameters.getInterfaceName());
        }
        IListenerInterfaceRequestTarget interfaceTarget = (IListenerInterfaceRequestTarget)rt;
        interfaceTarget.getRequestListenerInterface().invoke(page, interfaceTarget.getTarget());
    }

    private void formValidators_add(IFormValidator validator) {
        if (this.formValidators == null) {
            this.formValidators = validator;
        } else {
            int size = this.formValidators_size();
            IFormValidator[] validators = new IFormValidator[size + 1];
            for (int i = 0; i < size; ++i) {
                validators[i] = this.formValidators_get(i);
            }
            validators[size] = validator;
            this.formValidators = validators;
        }
    }

    private IFormValidator formValidators_get(int index) {
        if (this.formValidators == null) {
            throw new IndexOutOfBoundsException();
        }
        if (this.formValidators instanceof IFormValidator[]) {
            return ((IFormValidator[])this.formValidators)[index];
        }
        return (IFormValidator)this.formValidators;
    }

    private int formValidators_size() {
        if (this.formValidators == null) {
            return 0;
        }
        if (this.formValidators instanceof IFormValidator[]) {
            return ((IFormValidator[])this.formValidators).length;
        }
        return 1;
    }

    private void inputChanged() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.inputChanged();
                }
            }
        });
    }

    private void persistFormComponentData() {
        if (this.getRequestCycle() instanceof WebRequestCycle) {
            final IValuePersister persister = this.getValuePersister();
            this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

                public void onFormComponent(FormComponent formComponent) {
                    if (formComponent.isVisibleInHierarchy()) {
                        if (formComponent.isPersistent()) {
                            persister.save(formComponent);
                        } else {
                            persister.clear(formComponent);
                        }
                    }
                }
            });
        }
    }

    protected void appendDefaultButtonField(MarkupStream markupStream, ComponentTag openTag) {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append("<div style=\"width:0px;height:0px;position:absolute;left:-100px;top:-100px;overflow:hidden\">");
        buffer.append("<input type=\"text\" autocomplete=\"false\"/>");
        Component submittingComponent = (Component)((Object)this.defaultSubmittingComponent);
        buffer.append("<input type=\"submit\" name=\"");
        buffer.append(this.defaultSubmittingComponent.getInputName());
        buffer.append("\" onclick=\" var b=document.getElementById('");
        buffer.append(submittingComponent.getMarkupId());
        buffer.append("'); if (b!=null&&b.onclick!=null&&typeof(b.onclick) != 'undefined') {  var r = b.onclick.bind(b)(); if (r != false) b.click(); } else { b.click(); };  return false;\" ");
        buffer.append(" />");
        buffer.append("</div>");
        this.getResponse().write(buffer);
    }

    protected void beforeUpdateFormComponentModels() {
    }

    protected void delegateSubmit(IFormSubmittingComponent submittingComponent) {
        Form formToProcess = this;
        if (submittingComponent != null) {
            formToProcess = submittingComponent.getForm();
            submittingComponent.onSubmit();
        }
        formToProcess.onSubmit();
        formToProcess.visitChildren(Form.class, new Component.IVisitor(){

            public Object component(Component component) {
                Form form = (Form)component;
                if (form.isEnabled() && form.isEnableAllowed() && form.isVisibleInHierarchy()) {
                    form.onSubmit();
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    protected final String getHiddenFieldId() {
        return this.getInputNamePrefix() + this.getJavascriptId() + "_hf_0";
    }

    protected final String getJavascriptId() {
        return this.getMarkupId();
    }

    protected String getMethod() {
        String method = this.getMarkupAttributes().getString("method");
        return method != null ? method : METHOD_POST;
    }

    protected boolean getStatelessHint() {
        return false;
    }

    protected IValuePersister getValuePersister() {
        return new CookieValuePersister();
    }

    private boolean isMultiPart() {
        if (this.multiPart) {
            return true;
        }
        final boolean[] anyEmbeddedMultipart = new boolean[]{false};
        this.visitChildren(Form.class, new Component.IVisitor(){

            public Object component(Component component) {
                Form form = (Form)component;
                if (form.multiPart) {
                    anyEmbeddedMultipart[0] = true;
                    return STOP_TRAVERSAL;
                }
                return CONTINUE_TRAVERSAL;
            }
        });
        return anyEmbeddedMultipart[0];
    }

    protected boolean handleMultiPart() {
        if (this.isMultiPart() && !((WebRequest)this.getRequest()).isAjax()) {
            try {
                WebRequest multipartWebRequest = ((WebRequest)this.getRequest()).newMultipartWebRequest(this.getMaxSize());
                this.getRequestCycle().setRequest(multipartWebRequest);
            }
            catch (WicketRuntimeException wre) {
                if (wre.getCause() == null || !(wre.getCause() instanceof FileUploadException)) {
                    throw wre;
                }
                FileUploadException e = (FileUploadException)wre.getCause();
                HashMap<String, Serializable> model = new HashMap<String, Serializable>();
                model.put("exception", e);
                model.put("maxSize", this.getMaxSize());
                if (e instanceof FileUploadBase.SizeLimitExceededException) {
                    String defaultValue = "Upload must be less than " + this.getMaxSize();
                    String msg = this.getString(this.getId() + "." + UPLOAD_TOO_LARGE_RESOURCE_KEY, Model.valueOf(model), defaultValue);
                    this.error((Serializable)((Object)msg));
                } else {
                    String defaultValue = "Upload failed: " + e.getLocalizedMessage();
                    String msg = this.getString(this.getId() + "." + UPLOAD_FAILED_RESOURCE_KEY, Model.valueOf(model), defaultValue);
                    this.error((Serializable)((Object)msg));
                    log.warn(msg, (Throwable)e);
                }
                return false;
            }
        }
        return true;
    }

    protected void internalOnModelChanged() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                if (formComponent.sameInnermostModel(Form.this)) {
                    formComponent.modelChanged();
                }
            }
        });
    }

    protected final void markFormComponentsInvalid() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.invalid();
                }
            }
        });
    }

    protected final void markFormComponentsValid() {
        this.internalMarkFormComponentsValid();
        this.markNestedFormComponentsValid();
    }

    private void markNestedFormComponentsValid() {
        this.visitChildren(Form.class, new Component.IVisitor(){

            public Object component(Component component) {
                Form form = (Form)component;
                if (form.isEnableAllowed() && form.isEnabled() && form.isVisibleInHierarchy()) {
                    form.internalMarkFormComponentsValid();
                    return CONTINUE_TRAVERSAL;
                }
                return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    private void internalMarkFormComponentsValid() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                if (formComponent.getForm() == Form.this && formComponent.isVisibleInHierarchy()) {
                    formComponent.valid();
                }
            }
        });
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "form");
        if (this.isRootForm()) {
            String method = this.getMethod().toLowerCase();
            tag.put("method", method);
            String url = ((Object)this.urlFor(IFormSubmitListener.INTERFACE)).toString();
            if (method.equals(METHOD_GET)) {
                int i = url.indexOf(63);
                String action = i > -1 ? url.substring(0, i) : "";
                tag.put("action", action);
            } else {
                tag.put("action", Strings.escapeMarkup(url));
            }
            if (this.isMultiPart()) {
                tag.put("enctype", "multipart/form-data");
            } else {
                String enctype = (String)tag.getAttributes().get("enctype");
                if ("multipart/form-data".equalsIgnoreCase(enctype)) {
                    this.setMultiPart(true);
                }
            }
        } else {
            tag.setName("div");
            tag.remove("method");
            tag.remove("action");
            tag.remove("enctype");
        }
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (this.isRootForm()) {
            Component submittingComponent;
            String nameAndId = this.getHiddenFieldId();
            AppendingStringBuffer buffer = new AppendingStringBuffer("<div style=\"display:none\"><input type=\"hidden\" name=\"").append(nameAndId).append("\" id=\"").append(nameAndId).append("\" />");
            String method = this.getMethod().toLowerCase();
            if (method.equals(METHOD_GET)) {
                String url = ((Object)this.urlFor(IFormSubmitListener.INTERFACE)).toString();
                int i = url.indexOf(63);
                String[] params = (i > -1 ? url.substring(i + 1) : url).split("&");
                for (int j = 0; j < params.length; ++j) {
                    String[] pair = params[j].split("=");
                    buffer.append("<input type=\"hidden\" name=\"").append(pair[0]).append("\" value=\"").append(pair.length > 1 ? pair[1] : "").append("\" />");
                }
            }
            buffer.append("</div>");
            this.getResponse().write(buffer);
            if (this.defaultSubmittingComponent instanceof Component && (submittingComponent = (Component)((Object)this.defaultSubmittingComponent)).isVisibleInHierarchy() && submittingComponent.isEnabled()) {
                this.appendDefaultButtonField(markupStream, openTag);
            }
        }
        super.onComponentTagBody(markupStream, openTag);
    }

    protected void writeParamsAsHiddenFields(String[] params, AppendingStringBuffer buffer) {
        for (int j = 0; j < params.length; ++j) {
            String[] pair = params[j].split("=");
            buffer.append("<input type=\"hidden\" name=\"").append(this.recode(pair[0])).append("\" value=\"").append(pair.length > 1 ? this.recode(pair[1]) : "").append("\" />");
        }
    }

    private String recode(String s) {
        String un = WicketURLDecoder.QUERY_INSTANCE.decode(s);
        return ((Object)Strings.escapeMarkup(un)).toString();
    }

    protected void onDetach() {
        super.internalOnDetach();
        this.setFlag((short)256, false);
        super.onDetach();
    }

    protected void onError() {
    }

    protected void onRender(MarkupStream markupStream) {
        this.visitFormComponents(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                if (formComponent.isVisible() && formComponent.isMultiPart()) {
                    Form.this.setMultiPart(true);
                }
            }
        });
        super.onRender(markupStream);
    }

    protected void onSubmit() {
    }

    protected final void updateFormComponentModels() {
        this.internalUpdateFormComponentModels();
        this.updateNestedFormComponentModels();
    }

    private final void updateNestedFormComponentModels() {
        this.visitChildren(Form.class, new Component.IVisitor(){

            public Object component(Component component) {
                Form form = (Form)component;
                if (form.isEnabled() && form.isEnableAllowed() && form.isVisibleInHierarchy()) {
                    form.internalUpdateFormComponentModels();
                    return CONTINUE_TRAVERSAL;
                }
                return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    private void internalUpdateFormComponentModels() {
        this.visitFormComponentsPostOrder(new ValidationVisitor(){

            public void validate(FormComponent formComponent) {
                Form form = formComponent.getForm();
                if (form == Form.this) {
                    formComponent.updateModel();
                }
            }
        });
    }

    protected void validate() {
        if (this.isEnabled() && this.isEnableAllowed() && this.isVisibleInHierarchy()) {
            this.validateComponents();
            this.validateFormValidators();
            this.validateNestedForms();
        }
    }

    protected final void validateComponents() {
        this.visitFormComponentsPostOrder(new ValidationVisitor(){

            public void validate(FormComponent formComponent) {
                Form form = formComponent.getForm();
                if (form == Form.this && form.isEnabled() && form.isEnableAllowed() && form.isVisibleInHierarchy()) {
                    formComponent.validate();
                }
            }
        });
    }

    private boolean isFormComponentVisibleInPage(FormComponent fc) {
        if (fc == null) {
            throw new IllegalArgumentException("Argument `fc` cannot be null");
        }
        return fc.isVisibleInHierarchy();
    }

    protected final void validateFormValidator(IFormValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("Argument [[validator]] cannot be null");
        }
        FormComponent[] dependents = validator.getDependentFormComponents();
        boolean validate = true;
        if (dependents != null) {
            for (int j = 0; j < dependents.length; ++j) {
                FormComponent dependent = dependents[j];
                if (!dependent.isValid()) {
                    validate = false;
                    break;
                }
                if (this.isFormComponentVisibleInPage(dependent)) continue;
                if (log.isWarnEnabled()) {
                    log.warn("IFormValidator in form `" + this.getPageRelativePath() + "` depends on a component that has been removed from the page or is no longer visible. " + "Offending component id `" + dependent.getId() + "`.");
                }
                validate = false;
                break;
            }
        }
        if (validate) {
            validator.validate(this);
        }
    }

    protected final void validateFormValidators() {
        int count = this.formValidators_size();
        for (int i = 0; i < count; ++i) {
            this.validateFormValidator(this.formValidators_get(i));
        }
    }

    private void validateNestedForms() {
        this.visitChildren(Form.class, new Component.IVisitor(){

            public Object component(Component component) {
                Form form = (Form)component;
                if (form.isEnabled() && form.isEnableAllowed() && form.isVisibleInHierarchy()) {
                    form.validateComponents();
                    form.validateFormValidators();
                    return CONTINUE_TRAVERSAL;
                }
                return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    protected String getInputNamePrefix() {
        return "";
    }

    private class FormValidatorRemovedChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final IFormValidator removed;

        public FormValidatorRemovedChange(IFormValidator removed) {
            this.removed = removed;
        }

        public void undo() {
            Form.this.add(this.removed);
        }
    }

    class FormDispatchRequest
    extends Request {
        private final ValueMap params = new ValueMap();
        private final Request realRequest;
        private final String url;

        public FormDispatchRequest(Request realRequest, String url) {
            this.realRequest = realRequest;
            this.url = realRequest.decodeURL(url);
            String queryString = this.url.substring(this.url.indexOf("?") + 1);
            RequestUtils.decodeParameters(queryString, this.params);
        }

        public Locale getLocale() {
            return this.realRequest.getLocale();
        }

        public String getParameter(String key) {
            return (String)this.params.get(key);
        }

        public Map getParameterMap() {
            return this.params;
        }

        public String[] getParameters(String key) {
            String param = (String)this.params.get(key);
            if (param != null) {
                return new String[]{param};
            }
            return new String[0];
        }

        public String getPath() {
            return this.realRequest.getPath();
        }

        public String getRelativePathPrefixToContextRoot() {
            return this.realRequest.getRelativePathPrefixToContextRoot();
        }

        public String getRelativePathPrefixToWicketHandler() {
            return this.realRequest.getRelativePathPrefixToWicketHandler();
        }

        public String getURL() {
            return this.url;
        }
    }

    public static abstract class ValidationVisitor
    implements FormComponent.IVisitor {
        public Object formComponent(IFormVisitorParticipant component) {
            if (component instanceof FormComponent) {
                FormComponent formComponent = (FormComponent)component;
                Form form = formComponent.getForm();
                if (!(form.isEnabled() && form.isEnableAllowed() && form.isVisibleInHierarchy())) {
                    return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                }
                if (formComponent.isVisibleInHierarchy() && formComponent.isValid() && formComponent.isEnabled() && formComponent.isEnableAllowed()) {
                    this.validate(formComponent);
                }
            }
            if (component.processChildren()) {
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
            return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
        }

        public abstract void validate(FormComponent var1);
    }
}

