/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import org.apache.wicket.RequestContext;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;

public class DropDownChoice
extends AbstractSingleSelectChoice
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;

    public DropDownChoice(String id) {
        super(id);
    }

    public DropDownChoice(String id, List choices) {
        super(id, choices);
    }

    public DropDownChoice(String id, List data, IChoiceRenderer renderer) {
        super(id, data, renderer);
    }

    public DropDownChoice(String id, IModel model, List choices) {
        super(id, model, choices);
    }

    public DropDownChoice(String id, IModel model, List data, IChoiceRenderer renderer) {
        super(id, model, data, renderer);
    }

    public DropDownChoice(String id, IModel choices) {
        super(id, choices);
    }

    public DropDownChoice(String id, IModel model, IModel choices) {
        super(id, model, choices);
    }

    public DropDownChoice(String id, IModel choices, IChoiceRenderer renderer) {
        super(id, choices, renderer);
    }

    public DropDownChoice(String id, IModel model, IModel choices, IChoiceRenderer renderer) {
        super(id, model, choices, renderer);
    }

    public final void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged(this.getModelObject());
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "select");
        if (this.wantOnSelectionChangedNotifications()) {
            CharSequence url = this.urlFor(IOnChangeListener.INTERFACE);
            Form form = (Form)this.findParent(Form.class);
            if (form != null) {
                RequestContext rc = RequestContext.get();
                if (rc.isPortletRequest()) {
                    url = ((PortletRequestContext)rc).getLastEncodedPath();
                }
                tag.put("onchange", form.getJsForInterfaceUrl(url));
            } else {
                tag.put("onchange", "window.location.href='" + url + (((Object)url).toString().indexOf(63) > -1 ? "&amp;" : "?") + this.getInputName() + "=' + this.options[this.selectedIndex].value;");
            }
        }
        super.onComponentTag(tag);
    }

    protected void onSelectionChanged(Object newSelection) {
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }
}

