/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.IDestroyer;
import org.apache.wicket.IInitializer;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Request;
import org.apache.wicket.RequestContext;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.SharedResources;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.application.IComponentOnAfterRenderListener;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.markup.IMarkupCache;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.image.resource.DefaultButtonImageResourceFactory;
import org.apache.wicket.markup.parser.filter.RelativePathPrefixHandler;
import org.apache.wicket.markup.parser.filter.WicketMessageTagHandler;
import org.apache.wicket.markup.resolver.AutoComponentResolver;
import org.apache.wicket.markup.resolver.BorderBodyResolver;
import org.apache.wicket.markup.resolver.EnclosureResolver;
import org.apache.wicket.markup.resolver.FragmentResolver;
import org.apache.wicket.markup.resolver.HtmlHeaderResolver;
import org.apache.wicket.markup.resolver.MarkupInheritanceResolver;
import org.apache.wicket.markup.resolver.ParentResolver;
import org.apache.wicket.markup.resolver.WicketContainerResolver;
import org.apache.wicket.markup.resolver.WicketLinkResolver;
import org.apache.wicket.markup.resolver.WicketMessageResolver;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.settings.IApplicationSettings;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.settings.IExceptionSettings;
import org.apache.wicket.settings.IFrameworkSettings;
import org.apache.wicket.settings.IMarkupSettings;
import org.apache.wicket.settings.IPageSettings;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.settings.IRequestLoggerSettings;
import org.apache.wicket.settings.IResourceSettings;
import org.apache.wicket.settings.ISecuritySettings;
import org.apache.wicket.settings.ISessionSettings;
import org.apache.wicket.settings.Settings;
import org.apache.wicket.util.convert.ConverterLocator;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.lang.PropertyResolver;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Application {
    public static final String CONFIGURATION = "configuration";
    public static final String CONTEXTPATH = "contextpath";
    public static final String DEPLOYMENT = "deployment";
    public static final String DEVELOPMENT = "development";
    private static final Map applicationKeyToApplication = new HashMap(1);
    private static final ThreadLocal current = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger((Class)Application.class);
    private IComponentInstantiationListener[] componentInstantiationListeners = new IComponentInstantiationListener[0];
    private IConverterLocator converterLocator;
    private final List initializers = new ArrayList();
    private MetaDataEntry[] metaData;
    private final String name = Classes.simpleName(this.getClass());
    private IRequestLogger requestLogger;
    private ISessionStore sessionStore;
    private Settings settings;
    private boolean settingsAccessible;
    private final SharedResources sharedResources = new SharedResources(this);
    private List componentOnBeforeRenderListeners = null;
    private List componentOnAfterRenderListeners = null;
    private List renderHeadListeners = null;

    public static boolean exists() {
        return current.get() != null;
    }

    public static Application get() {
        Application application = (Application)current.get();
        if (application == null) {
            throw new WicketRuntimeException("There is no application attached to current thread " + Thread.currentThread().getName());
        }
        return application;
    }

    public static Application get(String applicationKey) {
        Application application = (Application)applicationKeyToApplication.get(applicationKey);
        return application;
    }

    public static Set getApplicationKeys() {
        return Collections.unmodifiableSet(applicationKeyToApplication.keySet());
    }

    public static void set(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("Argument application can not be null");
        }
        current.set(application);
    }

    public static void unset() {
        current.set(null);
    }

    public Application() {
        this.addComponentInstantiationListener(new IComponentInstantiationListener(){

            public void onInstantiation(Component component) {
                if (!Session.get().getAuthorizationStrategy().isInstantiationAuthorized(component.getClass())) {
                    Application.this.getSecuritySettings().getUnauthorizedComponentInstantiationListener().onUnauthorizedInstantiation(component);
                }
            }
        });
    }

    public final void addComponentInstantiationListener(IComponentInstantiationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("argument listener may not be null");
        }
        for (int i = 0; i < this.componentInstantiationListeners.length; ++i) {
            if (listener != this.componentInstantiationListeners[i]) continue;
            return;
        }
        IComponentInstantiationListener[] newListeners = new IComponentInstantiationListener[this.componentInstantiationListeners.length + 1];
        System.arraycopy(this.componentInstantiationListeners, 0, newListeners, 0, this.componentInstantiationListeners.length);
        newListeners[this.componentInstantiationListeners.length] = listener;
        this.componentInstantiationListeners = newListeners;
    }

    public final void configure() {
        String configurationType = this.getConfigurationType();
        if (DEVELOPMENT.equalsIgnoreCase(configurationType)) {
            this.getResourceSettings().setResourcePollFrequency(Duration.ONE_SECOND);
            this.getDebugSettings().setComponentUseCheck(true);
            this.getMarkupSettings().setStripWicketTags(false);
            this.getExceptionSettings().setUnexpectedExceptionDisplay(IExceptionSettings.SHOW_EXCEPTION_PAGE);
            this.getDebugSettings().setAjaxDebugModeEnabled(true);
            this.getResourceSettings().setStripJavascriptCommentsAndWhitespace(false);
        } else if (DEPLOYMENT.equalsIgnoreCase(configurationType)) {
            this.getResourceSettings().setResourcePollFrequency(null);
            this.getDebugSettings().setComponentUseCheck(false);
            this.getMarkupSettings().setStripWicketTags(true);
            this.getExceptionSettings().setUnexpectedExceptionDisplay(IExceptionSettings.SHOW_INTERNAL_ERROR_PAGE);
            this.getDebugSettings().setAjaxDebugModeEnabled(false);
            this.getResourceSettings().setStripJavascriptCommentsAndWhitespace(true);
        } else {
            throw new IllegalArgumentException("Invalid configuration type: '" + configurationType + "'.  Must be \"development\" or \"deployment\".");
        }
    }

    public abstract String getApplicationKey();

    public IApplicationSettings getApplicationSettings() {
        return this.getSettings();
    }

    public abstract String getConfigurationType();

    public final IConverterLocator getConverterLocator() {
        return this.converterLocator;
    }

    public IDebugSettings getDebugSettings() {
        return this.getSettings();
    }

    public IExceptionSettings getExceptionSettings() {
        return this.getSettings();
    }

    public IFrameworkSettings getFrameworkSettings() {
        return this.getSettings();
    }

    public abstract Class getHomePage();

    public final IMarkupCache getMarkupCache() {
        return this.getMarkupSettings().getMarkupCache();
    }

    public IMarkupSettings getMarkupSettings() {
        return this.getSettings();
    }

    public final Serializable getMetaData(MetaDataKey key) {
        return (Serializable)key.get(this.metaData);
    }

    public final String getName() {
        return this.name;
    }

    public IPageSettings getPageSettings() {
        return this.getSettings();
    }

    public IRequestCycleSettings getRequestCycleSettings() {
        return this.getSettings();
    }

    public final IRequestLogger getRequestLogger() {
        if (this.getRequestLoggerSettings().isRequestLoggerEnabled()) {
            if (this.requestLogger == null) {
                this.requestLogger = this.newRequestLogger();
            }
        } else {
            this.requestLogger = null;
        }
        return this.requestLogger;
    }

    public IRequestLoggerSettings getRequestLoggerSettings() {
        return this.getSettings();
    }

    public IResourceSettings getResourceSettings() {
        return this.getSettings();
    }

    public ISecuritySettings getSecuritySettings() {
        return this.getSettings();
    }

    public ISessionSettings getSessionSettings() {
        return this.getSettings();
    }

    public final ISessionStore getSessionStore() {
        return this.sessionStore;
    }

    public final SharedResources getSharedResources() {
        return this.sharedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initializeComponents() {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("wicket.properties");
            while (resources.hasMoreElements()) {
                InputStream in = null;
                try {
                    URL url = resources.nextElement();
                    Properties properties = new Properties();
                    in = url.openStream();
                    properties.load(in);
                    this.load(properties);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Unable to load initializers file", e);
        }
        this.callInitializers();
    }

    public void logEventTarget(IRequestTarget target) {
    }

    public void logResponseTarget(IRequestTarget requestTarget) {
    }

    public abstract RequestCycle newRequestCycle(Request var1, Response var2);

    public final RequestCycle newRequestCycle(Application application, Request request, Response response) {
        throw new UnsupportedOperationException();
    }

    public abstract Session newSession(Request var1, Response var2);

    public final void removeComponentInstantiationListener(IComponentInstantiationListener listener) {
        IComponentInstantiationListener[] listeners = this.componentInstantiationListeners;
        int len = listeners.length;
        if (listener != null && len > 0) {
            int pos = 0;
            for (pos = 0; pos < len && listener != listeners[pos]; ++pos) {
            }
            if (pos < len) {
                listeners[pos] = listeners[len - 1];
                IComponentInstantiationListener[] newListeners = new IComponentInstantiationListener[len - 1];
                System.arraycopy(listeners, 0, newListeners, 0, newListeners.length);
                this.componentInstantiationListeners = newListeners;
            }
        }
    }

    public final synchronized void setMetaData(MetaDataKey key, Serializable object) {
        this.metaData = key.set(this.metaData, object);
    }

    private final void addInitializer(String className) {
        IInitializer initializer = (IInitializer)Objects.newInstance(className);
        if (initializer != null) {
            this.initializers.add(initializer);
        }
    }

    private final void callDestroyers() {
        Iterator i = this.initializers.iterator();
        while (i.hasNext()) {
            IInitializer initializer = (IInitializer)i.next();
            if (!(initializer instanceof IDestroyer)) continue;
            log.info("[" + this.getName() + "] destroy: " + initializer);
            ((IDestroyer)((Object)initializer)).destroy(this);
        }
    }

    private final void callInitializers() {
        Iterator i = this.initializers.iterator();
        while (i.hasNext()) {
            IInitializer initializer = (IInitializer)i.next();
            log.info("[" + this.getName() + "] init: " + initializer);
            initializer.init(this);
        }
    }

    private Settings getSettings() {
        if (!this.settingsAccessible) {
            throw new WicketRuntimeException("Use Application.init() method for configuring your application object");
        }
        if (this.settings == null) {
            this.settings = new Settings(this);
        }
        return this.settings;
    }

    private final void load(Properties properties) {
        this.addInitializer(properties.getProperty("initializer"));
        this.addInitializer(properties.getProperty(this.getName() + "-initializer"));
    }

    protected final void destroy() {
    }

    protected void onDestroy() {
    }

    protected final Object getRequestCycleFactory() {
        throw new UnsupportedOperationException();
    }

    protected final Object getSessionFactory() {
        throw new UnsupportedOperationException();
    }

    protected void init() {
    }

    protected void internalDestroy() {
        PropertyResolver.destroy(this);
        this.getMarkupSettings().getMarkupCache().shutdown();
        this.onDestroy();
        this.callDestroyers();
        applicationKeyToApplication.remove(this.getApplicationKey());
        Session.unset();
        RequestContext.unset();
        RequestCycle.set(null);
    }

    protected void internalInit() {
        this.settingsAccessible = true;
        IPageSettings pageSettings = this.getPageSettings();
        pageSettings.addComponentResolver(new ParentResolver());
        pageSettings.addComponentResolver(new AutoComponentResolver());
        pageSettings.addComponentResolver(new MarkupInheritanceResolver());
        pageSettings.addComponentResolver(new HtmlHeaderResolver());
        pageSettings.addComponentResolver(new WicketLinkResolver());
        pageSettings.addComponentResolver(new WicketMessageResolver());
        pageSettings.addComponentResolver(new WicketMessageTagHandler());
        pageSettings.addComponentResolver(new FragmentResolver());
        pageSettings.addComponentResolver(new RelativePathPrefixHandler());
        pageSettings.addComponentResolver(new EnclosureResolver());
        pageSettings.addComponentResolver(new WicketContainerResolver());
        pageSettings.addComponentResolver(new BorderBodyResolver());
        this.getResourceSettings().addResourceFactory("buttonFactory", new DefaultButtonImageResourceFactory());
        String applicationKey = this.getApplicationKey();
        applicationKeyToApplication.put(applicationKey, this);
        this.sessionStore = this.newSessionStore();
        this.converterLocator = this.newConverterLocator();
    }

    protected IConverterLocator newConverterLocator() {
        return new ConverterLocator();
    }

    protected IRequestLogger newRequestLogger() {
        return new RequestLogger();
    }

    protected abstract ISessionStore newSessionStore();

    final void notifyComponentInstantiationListeners(Component component) {
        int len = this.componentInstantiationListeners.length;
        for (int i = 0; i < len; ++i) {
            this.componentInstantiationListeners[i].onInstantiation(component);
        }
    }

    public final void addComponentOnBeforeRenderListener(IComponentOnBeforeRenderListener listener) {
        if (this.componentOnBeforeRenderListeners == null) {
            this.componentOnBeforeRenderListeners = new ArrayList();
        }
        if (!this.componentOnBeforeRenderListeners.contains(listener)) {
            this.componentOnBeforeRenderListeners.add(listener);
        }
    }

    public final void removeComponentOnBeforeRenderListener(IComponentOnBeforeRenderListener listener) {
        if (this.componentOnBeforeRenderListeners != null) {
            this.componentOnBeforeRenderListeners.remove(listener);
            if (this.componentOnBeforeRenderListeners.isEmpty()) {
                this.componentOnBeforeRenderListeners = null;
            }
        }
    }

    final void notifyComponentOnBeforeRenderListeners(Component component) {
        if (this.componentOnBeforeRenderListeners != null) {
            Iterator i = this.componentOnBeforeRenderListeners.iterator();
            while (i.hasNext()) {
                IComponentOnBeforeRenderListener listener = (IComponentOnBeforeRenderListener)i.next();
                listener.onBeforeRender(component);
            }
        }
    }

    public final void addComponentOnAfterRenderListener(IComponentOnAfterRenderListener listener) {
        if (this.componentOnAfterRenderListeners == null) {
            this.componentOnAfterRenderListeners = new ArrayList();
        }
        if (!this.componentOnAfterRenderListeners.contains(listener)) {
            this.componentOnAfterRenderListeners.add(listener);
        }
    }

    public final void removeComponentOnAfterRenderListener(IComponentOnAfterRenderListener listener) {
        if (this.componentOnAfterRenderListeners != null) {
            this.componentOnAfterRenderListeners.remove(listener);
            if (this.componentOnAfterRenderListeners.isEmpty()) {
                this.componentOnAfterRenderListeners = null;
            }
        }
    }

    final void notifyComponentOnAfterRenderListeners(Component component) {
        if (this.componentOnAfterRenderListeners != null) {
            Iterator i = this.componentOnAfterRenderListeners.iterator();
            while (i.hasNext()) {
                IComponentOnAfterRenderListener listener = (IComponentOnAfterRenderListener)i.next();
                listener.onAfterRender(component);
            }
        }
    }

    public final void addRenderHeadListener(IHeaderContributor listener) {
        if (this.renderHeadListeners == null) {
            this.renderHeadListeners = new ArrayList();
        }
        this.renderHeadListeners.add(listener);
    }

    public void removeRenderHeadListener(IHeaderContributor listener) {
        if (this.renderHeadListeners != null) {
            this.renderHeadListeners.remove(listener);
            if (this.renderHeadListeners.isEmpty()) {
                this.renderHeadListeners = null;
            }
        }
    }

    public void notifyRenderHeadListener(IHeaderResponse response) {
        if (this.renderHeadListeners != null) {
            Iterator i = this.renderHeadListeners.iterator();
            while (i.hasNext()) {
                IHeaderContributor listener = (IHeaderContributor)i.next();
                listener.renderHead(response);
            }
        }
    }
}

