/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.metastore.jdbc;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.MetaStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.StorageObject;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRangeObject;
import org.geowebcache.storage.WFSObject;
import org.geowebcache.storage.metastore.jdbc.JDBCMBIdCache;
import org.geowebcache.storage.metastore.jdbc.JDBCMBWrapper;

public class JDBCMetaBackend
implements MetaStore {
    private static Log log = LogFactory.getLog(JDBCMetaBackend.class);
    private JDBCMBWrapper wrpr;
    private final JDBCMBIdCache idCache;
    private long lockRetryDelay = 50L;
    private boolean enabled = true;

    public JDBCMetaBackend(String driverClass, String jdbcString, String username, String password) throws StorageException {
        try {
            this.wrpr = new JDBCMBWrapper(driverClass, jdbcString, username, password);
        }
        catch (SQLException se) {
            this.enabled = false;
            throw new StorageException(se.getMessage());
        }
        this.idCache = this.enabled ? new JDBCMBIdCache(this.wrpr) : null;
    }

    public JDBCMetaBackend(DefaultStorageFinder defStoreFind) throws StorageException {
        String metaStoreDisabled = defStoreFind.findEnvVar("GWC_METASTORE_DISABLED");
        if (metaStoreDisabled != null && Boolean.parseBoolean(metaStoreDisabled)) {
            this.enabled = false;
            this.wrpr = null;
            this.idCache = null;
        } else {
            try {
                this.wrpr = new JDBCMBWrapper(defStoreFind);
            }
            catch (SQLException se) {
                log.error((Object)("Failed to start JDBC metastore: " + se.getMessage()));
                log.warn((Object)"Disabling JDBC metastore, not all functionality will be available!");
                this.enabled = false;
                this.wrpr = null;
            }
            this.idCache = this.enabled ? new JDBCMBIdCache(this.wrpr) : null;
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean delete(String layerName) throws StorageException {
        long layerId = this.idCache.getLayerId(layerName);
        try {
            this.wrpr.deleteLayer(layerId);
            return true;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to delete layer: " + se.getMessage()));
            return false;
        }
    }

    public boolean delete(TileObject stObj) throws StorageException {
        stObj.setLayerId(this.idCache.getLayerId(stObj.getLayerName()));
        stObj.setFormatId(this.idCache.getFormatId(stObj.getBlobFormat()));
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            stObj.setParamtersId(this.idCache.getParametersId(stObj.getParameters()));
        }
        try {
            this.wrpr.deleteTile(stObj);
            return true;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to get tile: " + se.getMessage()));
            return false;
        }
    }

    public boolean delete(WFSObject stObj) throws StorageException {
        Long parameters_id = null;
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            parameters_id = this.idCache.getParametersId(stObj.getParameters());
        }
        try {
            this.wrpr.deleteWFS(parameters_id, stObj);
            return true;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to delete WFS object: " + se.getMessage()));
            return false;
        }
    }

    public boolean delete(BlobStore blobStore, TileRangeObject trObj) throws StorageException {
        long layerId = this.idCache.getLayerId(trObj.layerName);
        long formatId = this.idCache.getFormatId(trObj.mimeType.getFormat());
        long parametersId = trObj.parameters != null ? this.idCache.getParametersId(trObj.parameters) : -1L;
        long gridSetIdId = this.idCache.getGridSetsId(trObj.gridSetId);
        for (int zoomLevel = trObj.zoomStart; zoomLevel <= trObj.zoomStop; ++zoomLevel) {
            this.wrpr.deleteRange(blobStore, trObj, zoomLevel, layerId, formatId, parametersId, gridSetIdId);
        }
        return true;
    }

    public boolean expire(TileRangeObject trObj) throws StorageException {
        long layerId = this.idCache.getLayerId(trObj.layerName);
        long formatId = this.idCache.getFormatId(trObj.mimeType.getFormat());
        long parametersId = trObj.parameters != null ? this.idCache.getParametersId(trObj.parameters) : -1L;
        long gridSetIdId = this.idCache.getGridSetsId(trObj.gridSetId);
        for (int zoomLevel = trObj.zoomStart; zoomLevel <= trObj.zoomStop; ++zoomLevel) {
            try {
                this.wrpr.expireRange(trObj, zoomLevel, layerId, formatId, parametersId, gridSetIdId);
                continue;
            }
            catch (SQLException se) {
                log.error((Object)se.getMessage());
            }
        }
        return true;
    }

    public boolean get(TileObject stObj) throws StorageException {
        stObj.setLayerId(this.idCache.getLayerId(stObj.getLayerName()));
        stObj.setFormatId(this.idCache.getFormatId(stObj.getBlobFormat()));
        stObj.setGridSetIdId(this.idCache.getGridSetsId(stObj.getGridSetId()));
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            stObj.setParamtersId(this.idCache.getParametersId(stObj.getParameters()));
        }
        try {
            boolean response = this.wrpr.getTile(stObj);
            while (stObj.getStatus().equals((Object)StorageObject.Status.LOCK)) {
                try {
                    Thread.sleep(this.lockRetryDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                response = this.wrpr.getTile(stObj);
            }
            return response;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to get tile: " + se.getMessage()));
            return false;
        }
    }

    public boolean get(WFSObject stObj) throws StorageException {
        Long parameters_id = null;
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            parameters_id = this.idCache.getParametersId(stObj.getParameters());
        }
        try {
            boolean response = this.wrpr.getWFS(parameters_id, stObj);
            while (stObj.getStatus().equals((Object)StorageObject.Status.LOCK)) {
                try {
                    Thread.sleep(this.lockRetryDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                response = this.wrpr.getWFS(parameters_id, stObj);
            }
            return response;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to get WFS object: " + se.getMessage()));
            return false;
        }
    }

    public void put(TileObject stObj) throws StorageException {
        stObj.setLayerId(this.idCache.getLayerId(stObj.getLayerName()));
        stObj.setFormatId(this.idCache.getFormatId(stObj.getBlobFormat()));
        stObj.setGridSetIdId(this.idCache.getGridSetsId(stObj.getGridSetId()));
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            stObj.setParamtersId(this.idCache.getParametersId(stObj.getParameters()));
        }
        try {
            this.wrpr.deleteTile(stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to delete tile: " + se.getMessage()));
        }
        try {
            this.wrpr.putTile(stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to put tile: " + se.getMessage()));
        }
    }

    public void put(WFSObject stObj) throws StorageException {
        Long parameters_id = null;
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            parameters_id = this.idCache.getParametersId(stObj.getParameters());
        }
        try {
            this.wrpr.deleteWFS(parameters_id, stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to delete WFS object: " + se.getMessage()));
        }
        try {
            this.wrpr.putWFS(parameters_id, stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to put WFS object: " + se.getMessage()));
        }
    }

    public boolean unlock(TileObject stObj) throws StorageException {
        try {
            return this.wrpr.unlockTile(stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to unlock tile: " + se.getMessage()));
            return false;
        }
    }

    public boolean unlock(WFSObject stObj) throws StorageException {
        Long parameters_id = null;
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            parameters_id = this.idCache.getParametersId(stObj.getParameters());
        }
        try {
            return this.wrpr.unlockWFS(parameters_id, stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to unlock WFS object: " + se.getMessage()));
            return false;
        }
    }

    public void clear() throws StorageException {
        if (this.wrpr.driverClass.equals("org.h2.Driver")) {
            throw new StorageException("clear() has not been implemented for " + this.wrpr.driverClass);
        }
    }

    public void destroy() {
        if (this.wrpr != null) {
            this.wrpr.destroy();
        }
    }

    public void setLockTimeout(long lockTimeout) {
        this.wrpr.lockTimeout = lockTimeout;
    }

    public void setLockRetryDelay(long lockRetryDelay) {
        this.lockRetryDelay = lockRetryDelay;
    }
}

