/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.metastore.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.StorageObject;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRangeObject;
import org.geowebcache.storage.WFSObject;

class JDBCMBWrapper {
    private static Log log = LogFactory.getLog(JDBCMBWrapper.class);
    static int DB_VERSION = 120;
    final String jdbcString;
    final String username;
    final String password;
    final String driverClass;
    final Connection persistentConnection;
    boolean closing = false;
    protected long lockTimeout = 60000L;

    protected JDBCMBWrapper(String driverClass, String jdbcString, String username, String password) throws StorageException, SQLException {
        this.jdbcString = jdbcString;
        this.username = username;
        this.password = password;
        this.driverClass = driverClass;
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new StorageException("Class not found: " + cnfe.getMessage());
        }
        this.persistentConnection = this.getConnection();
        this.checkTables();
    }

    public JDBCMBWrapper(DefaultStorageFinder defStoreFind) throws StorageException, SQLException {
        String envStrUsername = defStoreFind.findEnvVar("GWC_METASTORE_USERNAME");
        String envStrPassword = defStoreFind.findEnvVar("GWC_METASTORE_PASSWORD");
        String envStrJdbcUrl = defStoreFind.findEnvVar("GWC_METASTORE_JDBC_URL");
        String envStrDriver = defStoreFind.findEnvVar("GWC_METASTORE_DRIVER_CLASS");
        this.username = envStrUsername != null ? envStrUsername : "sa";
        this.password = envStrPassword != null ? envStrPassword : "";
        this.driverClass = envStrDriver != null ? envStrDriver : "org.h2.Driver";
        if (envStrJdbcUrl != null) {
            this.jdbcString = envStrJdbcUrl;
        } else {
            String path = defStoreFind.getDefaultPath() + File.separator + "meta_jdbc_h2";
            File dir = new File(path);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new StorageException("Unable to create " + dir.getAbsolutePath() + " for H2 database.");
            }
            this.jdbcString = "jdbc:h2:file:" + path + File.separator + "gwc_metastore" + ";TRACE_LEVEL_FILE=0;AUTO_SERVER=TRUE";
        }
        try {
            Class.forName(this.driverClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new StorageException("Class not found: " + cnfe.getMessage());
        }
        this.persistentConnection = this.getConnection();
        this.checkTables();
    }

    protected Connection getConnection() throws SQLException {
        if (!this.closing) {
            Connection conn = DriverManager.getConnection(this.jdbcString, this.username, this.password);
            conn.setAutoCommit(true);
            return conn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTables() throws StorageException, SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.condCreate(conn, "LAYERS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(254) UNIQUE", "VALUE", null);
            this.condCreate(conn, "PARAMETERS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(254) UNIQUE", "VALUE", null);
            this.condCreate(conn, "FORMATS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(126) UNIQUE", "VALUE", null);
            this.condCreate(conn, "GRIDSETS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(126) UNIQUE", "VALUE", null);
            int fromVersion = this.getDbVersion(conn);
            log.info((Object)("MetaStore database is version " + fromVersion));
            if (fromVersion != DB_VERSION) {
                if (fromVersion < DB_VERSION) {
                    this.runDbUpgrade(conn, fromVersion);
                } else {
                    log.error((Object)"Metastore database is newer than the runnin version of GWC. Proceeding with undefined results.");
                }
            }
            this.checkWFSTable(conn);
            this.checkTilesTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getDbVersion(Connection conn) throws SQLException, StorageException {
        this.condCreate(conn, "VARIABLES", "KEY VARCHAR(32), VALUE VARCHAR(128)", "KEY", null);
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery("SELECT VALUE FROM VARIABLES WHERE KEY LIKE 'db_version'");
            if (rs.first()) {
                int cur_db_version;
                String db_versionStr = rs.getString("value");
                int n = cur_db_version = Integer.parseInt(db_versionStr);
                return n;
            }
            st.execute("INSERT INTO VARIABLES (KEY,VALUE)  VALUES ('db_version'," + DB_VERSION + ")");
            int n = DB_VERSION;
            return n;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    private void checkWFSTable(Connection conn) throws SQLException {
        this.condCreate(conn, "WFS", "WFS_ID BIGINT AUTO_INCREMENT PRIMARY KEY, PARAMETERS_ID BIGINT, QUERY_BLOB_MD5 VARCHAR(32), QUERY_BLOB_SIZE INT, BLOB_SIZE INT, CREATED BIGINT, ACCESS_LAST BIGINT, ACCESS_COUNT BIGINT, LOCK TIMESTAMP", "PARAMETERS_ID", "QUERY_BLOB_MD5, QUERY_BLOB_SIZE");
    }

    private void checkTilesTable(Connection conn) throws SQLException {
        this.condCreate(conn, "TILES", "TILE_ID BIGINT AUTO_INCREMENT PRIMARY KEY, LAYER_ID BIGINT, X BIGINT, Y BIGINT, Z BIGINT, GRIDSET_ID INT, FORMAT_ID BIGINT, PARAMETERS_ID BIGINT, BLOB_SIZE INT, CREATED BIGINT, ACCESS_LAST BIGINT, ACCESS_COUNT BIGINT, LOCK TIMESTAMP", "LAYER_ID, X, Y, Z, GRIDSET_ID, FORMAT_ID, PARAMETERS_ID", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void condCreate(Connection conn, String tableName, String columns, String indexColumns, String index2Columns) throws SQLException {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute("CREATE TABLE IF NOT EXISTS " + tableName + " (" + columns + ")");
            st.execute("CREATE INDEX IF NOT EXISTS IDX_" + tableName + " ON " + tableName + " (" + indexColumns + ")");
            if (index2Columns != null) {
                st.execute("CREATE INDEX IF NOT EXISTS IDX2_" + tableName + " ON " + tableName + " (" + index2Columns + ")");
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    private void runDbUpgrade(Connection conn, int fromVersion) {
        Statement st;
        PreparedStatement prep;
        String query;
        log.info((Object)("Upgrading  H2 database from " + fromVersion + " to " + DB_VERSION));
        boolean earlier = false;
        if (fromVersion == 110) {
            log.info((Object)"Running database upgrade from 110 to 111");
            earlier = true;
            try {
                query = "UPDATE VARIABLES SET VALUE = ? WHERE KEY = ?";
                prep = conn.prepareStatement(query);
                prep.setString(1, "111");
                prep.setString(2, "db_version");
                prep.execute();
                prep.close();
                query = "ALTER TABLE TILES ADD LOCK TIMESTAMP";
                st = conn.createStatement();
                st.execute(query);
                st.close();
                query = "ALTER TABLE WFS ADD LOCK TIMESTAMP";
                st = conn.createStatement();
                st.execute(query);
                st.close();
                log.info((Object)"Database upgrade from 110 to 111 completed");
            }
            catch (SQLException se) {
                log.error((Object)("110 to 111 upgrade failed: " + se.getMessage()));
            }
        }
        if (fromVersion == 111 || earlier) {
            log.info((Object)"Running database upgrade from 111 to 120");
            try {
                query = "UPDATE VARIABLES SET VALUE = ? WHERE KEY = ?";
                prep = conn.prepareStatement(query);
                prep.setString(1, "120");
                prep.setString(2, "db_version");
                prep.execute();
                prep.close();
                query = "ALTER TABLE TILES ALTER COLUMN SRS_ID RENAME TO GRIDSET_ID";
                st = conn.createStatement();
                st.execute(query);
                st.close();
                query = "SELECT GRIDSET_ID FROM TILES GROUP BY GRIDSET_ID";
                st = conn.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    int val = rs.getInt(1);
                    query = "INSERT INTO GRIDSETS (ID, VALUE) VALUES (?,?)";
                    prep = this.getConnection().prepareStatement(query);
                    prep.setLong(1, val);
                    prep.setString(2, "EPSG:" + val);
                    prep.executeUpdate();
                    prep.close();
                }
                rs.close();
                st.close();
                log.info((Object)"Database upgrade from 111 to 120 completed");
            }
            catch (SQLException se) {
                log.error((Object)("111 to 120 upgrade failed: " + se.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTile(TileObject stObj) throws SQLException {
        String query = stObj.getParametersId() == -1L ? "DELETE FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL" : "DELETE FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ?";
        long[] xyz = stObj.getXYZ();
        Connection conn = this.getConnection();
        PreparedStatement prep = conn.prepareStatement(query);
        prep.setLong(1, stObj.getLayerId());
        prep.setLong(2, xyz[0]);
        prep.setLong(3, xyz[1]);
        prep.setLong(4, xyz[2]);
        prep.setLong(5, stObj.getGridSetIdId());
        prep.setLong(6, stObj.getFormatId());
        if (stObj.getParametersId() != -1L) {
            prep.setLong(7, stObj.getParametersId());
        }
        try {
            prep.execute();
        }
        finally {
            prep.close();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteWFS(Long parameters, WFSObject wfsObj) throws SQLException {
        String query = null;
        PreparedStatement prep = null;
        Connection conn = this.getConnection();
        if (parameters != null) {
            query = "DELETE FROM WFS WHERE  PARAMETERS_ID = ?";
            prep = conn.prepareStatement(query);
            prep.setLong(1, parameters);
        } else {
            query = "DELETE FROM WFS WHERE  QUERY_BLOB_MD5 LIKE ? AND QUERY_BLOB_SIZE = ?";
            prep = conn.prepareStatement(query);
            prep.setString(1, wfsObj.getQueryBlobMd5());
            prep.setInt(2, wfsObj.getQueryBlobSize());
        }
        try {
            prep.execute();
        }
        finally {
            if (prep != null) {
                prep.close();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getTile(TileObject stObj) throws SQLException {
        String query = stObj.getParametersId() == -1L ? "SELECT TILE_ID,BLOB_SIZE,CREATED,LOCK,NOW() FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL LIMIT 1 " : "SELECT TILE_ID,BLOB_SIZE,CREATED,LOCK,NOW() FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ? LIMIT 1 ";
        long[] xyz = stObj.getXYZ();
        Connection conn = this.getConnection();
        PreparedStatement prep = conn.prepareStatement(query);
        prep.setLong(1, stObj.getLayerId());
        prep.setLong(2, xyz[0]);
        prep.setLong(3, xyz[1]);
        prep.setLong(4, xyz[2]);
        prep.setLong(5, stObj.getGridSetIdId());
        prep.setLong(6, stObj.getFormatId());
        if (stObj.getParametersId() != -1L) {
            prep.setLong(7, stObj.getParametersId());
        }
        ResultSet rs = null;
        try {
            rs = prep.executeQuery();
            if (rs.first()) {
                Timestamp lock = rs.getTimestamp(4);
                if (lock != null) {
                    Timestamp now = rs.getTimestamp(5);
                    long diff = now.getTime() - lock.getTime();
                    if (diff > this.lockTimeout) {
                        log.warn((Object)("Database lock exceeded (" + diff + "ms , " + lock.toString() + ") for " + stObj.toString() + ", clearing tile."));
                        this.deleteTile(stObj);
                        stObj.setStatus(StorageObject.Status.EXPIRED_LOCK);
                    } else {
                        stObj.setStatus(StorageObject.Status.LOCK);
                    }
                    boolean bl = false;
                    return bl;
                }
                stObj.setId(rs.getLong(1));
                stObj.setBlobSize(rs.getInt(2));
                stObj.setCreated(rs.getLong(3));
                stObj.setStatus(StorageObject.Status.HIT);
                boolean bl = true;
                return bl;
            }
            stObj.setStatus(StorageObject.Status.MISS);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (prep != null) {
                prep.close();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getWFS(Long parameters, WFSObject wfsObj) throws SQLException {
        String query = null;
        PreparedStatement prep = null;
        Connection conn = this.getConnection();
        if (parameters != null) {
            query = "SELECT WFS_ID,BLOB_SIZE,CREATED,LOCK,NOW() FROM WFS WHERE  PARAMETERS_ID = ? LIMIT 1 ";
            prep = conn.prepareStatement(query);
            prep.setLong(1, parameters);
        } else {
            query = "SELECT WFS_ID,BLOB_SIZE,CREATED,LOCK,NOW() FROM WFS WHERE  QUERY_BLOB_MD5 LIKE ? AND QUERY_BLOB_SIZE = ? LIMIT 1";
            prep = conn.prepareStatement(query);
            prep.setString(1, wfsObj.getQueryBlobMd5());
            prep.setInt(2, wfsObj.getQueryBlobSize());
        }
        ResultSet rs = null;
        try {
            rs = prep.executeQuery();
            if (rs.next()) {
                Timestamp lock = rs.getTimestamp(4);
                if (lock != null) {
                    Timestamp now = rs.getTimestamp(5);
                    if (now.getTime() - lock.getTime() > this.lockTimeout) {
                        log.warn((Object)("Database lock exceeded for " + wfsObj.toString() + ", clearing WFS object."));
                        this.deleteWFS(parameters, wfsObj);
                        wfsObj.setStatus(StorageObject.Status.EXPIRED_LOCK);
                    } else {
                        wfsObj.setStatus(StorageObject.Status.LOCK);
                    }
                    boolean bl = false;
                    return bl;
                }
                wfsObj.setId(rs.getLong(1));
                wfsObj.setBlobSize(rs.getInt(2));
                wfsObj.setCreated(rs.getLong(3));
                wfsObj.setStatus(StorageObject.Status.HIT);
                boolean bl = true;
                return bl;
            }
            wfsObj.setStatus(StorageObject.Status.MISS);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (prep != null) {
                prep.close();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTile(TileObject stObj) throws SQLException, StorageException {
        String query = "MERGE INTO TILES(LAYER_ID,X,Y,Z,GRIDSET_ID,FORMAT_ID,PARAMETERS_ID,BLOB_SIZE,LOCK) KEY(LAYER_ID,X,Y,Z,GRIDSET_ID,FORMAT_ID,PARAMETERS_ID) VALUES(?,?,?,?,?,?,?,?,NOW())";
        long[] xyz = stObj.getXYZ();
        Connection conn = this.getConnection();
        try {
            PreparedStatement prep = conn.prepareStatement(query, 1);
            prep.setLong(1, stObj.getLayerId());
            prep.setLong(2, xyz[0]);
            prep.setLong(3, xyz[1]);
            prep.setLong(4, xyz[2]);
            prep.setLong(5, stObj.getGridSetIdId());
            prep.setLong(6, stObj.getFormatId());
            if (stObj.getParametersId() == -1L) {
                prep.setNull(7, -5);
            } else {
                prep.setLong(7, stObj.getParametersId());
            }
            prep.setInt(8, stObj.getBlobSize());
            Long insertId = this.wrappedInsert(prep);
            if (insertId == null) {
                log.error((Object)("Did not receive a id for " + query));
            } else {
                stObj.setId(insertId);
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putWFS(Long parameters, WFSObject stObj) throws SQLException, StorageException {
        PreparedStatement prep = null;
        String query = null;
        Connection conn = this.getConnection();
        try {
            if (parameters != null) {
                query = "MERGE INTO WFS(PARAMETERS_ID,BLOB_SIZE,CREATED,LOCK) KEY(PARAMETERS_ID) VALUES(?,?,?,NOW())";
                prep = conn.prepareStatement(query, 1);
                prep.setLong(1, parameters);
                prep.setInt(2, stObj.getBlobSize());
                prep.setLong(3, stObj.getCreated());
            } else {
                query = "MERGE INTO WFS(QUERY_BLOB_MD5, QUERY_BLOB_SIZE,BLOB_SIZE,CREATED,LOCK) KEY(QUERY_BLOB_MD5, QUERY_BLOB_SIZE) VALUES(?,?,?,?,NOW())";
                prep = conn.prepareStatement(query, 1);
                prep.setString(1, stObj.getQueryBlobMd5());
                prep.setInt(2, stObj.getQueryBlobSize());
                prep.setInt(3, stObj.getBlobSize());
                prep.setLong(4, stObj.getCreated());
            }
            Long insertId = this.wrappedInsert(prep);
            if (insertId == null) {
                log.error((Object)("Did not receive a id for " + query));
            } else if (insertId == 0L) {
                this.getWFS(parameters, stObj);
            } else {
                stObj.setId(insertId);
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockTile(TileObject stObj) throws SQLException, StorageException {
        String query = null;
        query = stObj.getParametersId() == -1L ? "UPDATE TILES SET LOCK = NULL WHERE   LAYER_ID = ? AND X = ? AND Y = ? AND Z = ?  AND GRIDSET_ID = ? AND FORMAT_ID = ? AND  PARAMETERS_ID IS NULL" : "UPDATE TILES SET LOCK = NULL WHERE   LAYER_ID = ? AND X = ? AND Y = ? AND Z = ?  AND GRIDSET_ID = ? AND FORMAT_ID = ? AND  PARAMETERS_ID = ?";
        long[] xyz = stObj.getXYZ();
        Connection conn = this.getConnection();
        PreparedStatement prep = null;
        try {
            int affected;
            prep = conn.prepareStatement(query);
            prep.setLong(1, stObj.getLayerId());
            prep.setLong(2, xyz[0]);
            prep.setLong(3, xyz[1]);
            prep.setLong(4, xyz[2]);
            prep.setLong(5, stObj.getGridSetIdId());
            prep.setLong(6, stObj.getFormatId());
            if (stObj.getParametersId() != -1L) {
                prep.setLong(7, stObj.getParametersId());
            }
            if ((affected = prep.executeUpdate()) == 1) {
                boolean bl = true;
                return bl;
            }
            log.error((Object)("Expected to clear lock on one row, but got " + affected));
            boolean bl = false;
            return bl;
        }
        finally {
            if (prep != null) {
                prep.close();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockWFS(Long parameters, WFSObject stObj) throws SQLException, StorageException {
        Statement prep = null;
        String query = null;
        Connection conn = this.getConnection();
        try {
            if (parameters != null) {
                query = "UPDATE WFS SET LOCK = NULL WHERE PARAMETERS_ID = ? ";
                prep = conn.prepareStatement(query);
                prep.setLong(1, parameters);
            } else {
                query = "UPDATE WFS SET LOCK = NULL WHERE QUERY_BLOB_MD5 = ? AND QUERY_BLOB_SIZE = ?";
                prep = conn.prepareStatement(query);
                prep.setString(1, stObj.getQueryBlobMd5());
                prep.setInt(2, stObj.getQueryBlobSize());
            }
            int affected = prep.executeUpdate();
            if (affected == 1) {
                boolean bl = true;
                return bl;
            }
            log.error((Object)("Expected to clear lock on one row, but got " + affected));
            boolean bl = false;
            return bl;
        }
        finally {
            if (prep != null) {
                prep.close();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long wrappedInsert(PreparedStatement st) throws SQLException {
        ResultSet rs = null;
        try {
            st.executeUpdate();
            rs = st.getGeneratedKeys();
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        this.closing = true;
        try {
            this.persistentConnection.createStatement().execute("SHUTDOWN");
        }
        catch (SQLException se) {
            log.warn((Object)("SHUTDOWN call to JDBC resulted in: " + se.getMessage()));
        }
        finally {
            try {
                this.persistentConnection.close();
            }
            catch (SQLException se) {
                log.warn((Object)se.getMessage());
            }
        }
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.gc();
    }

    private ResultSet getTileSet(long layerId, long formatId, long parametersId, long zoomLevel, long[] bounds, long srsNumber) throws SQLException {
        String query = parametersId == -1L ? "SELECT TILE_ID, X, Y, Z FROM TILES WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL" : "SELECT TILE_ID, X, Y, Z FROM TILES WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ?";
        Connection conn = this.getConnection();
        PreparedStatement prep = conn.prepareStatement(query);
        prep.setLong(1, layerId);
        prep.setLong(2, bounds[0]);
        prep.setLong(3, bounds[2]);
        prep.setLong(4, bounds[1]);
        prep.setLong(5, bounds[3]);
        prep.setLong(6, zoomLevel);
        prep.setLong(7, srsNumber);
        prep.setLong(8, formatId);
        if (parametersId != -1L) {
            prep.setLong(9, parametersId);
        }
        return prep.executeQuery();
    }

    private void deleteRange(long layerId, long formatId, long parametersId, int zoomLevel, long[] bounds, long gridSetIdId) throws SQLException {
        String query = parametersId == -1L ? "DELETE FROM TILES WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL" : "DELETE FROM TILES WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ?";
        Connection conn = this.getConnection();
        PreparedStatement prep = conn.prepareStatement(query);
        prep.setLong(1, layerId);
        prep.setLong(2, bounds[0]);
        prep.setLong(3, bounds[2]);
        prep.setLong(4, bounds[1]);
        prep.setLong(5, bounds[3]);
        prep.setLong(6, zoomLevel);
        prep.setLong(7, gridSetIdId);
        prep.setLong(8, formatId);
        if (parametersId != -1L) {
            prep.setLong(9, parametersId);
        }
        prep.execute();
    }

    public void deleteLayer(long layerId) throws SQLException {
        String query = "DELETE FROM TILES WHERE LAYER_ID = ?";
        Connection conn = this.getConnection();
        PreparedStatement prep = conn.prepareStatement(query);
        prep.setLong(1, layerId);
        prep.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRange(BlobStore blobStore, TileRangeObject trObj, int zoomLevel, long layerId, long formatId, long parametersId, long gridSetIdId) {
        long[] bounds = trObj.rangeBounds[zoomLevel];
        ResultSet rs = null;
        try {
            rs = this.getTileSet(layerId, formatId, parametersId, zoomLevel, bounds, gridSetIdId);
            while (rs.next()) {
                long[] xyz = new long[]{rs.getLong(2), rs.getLong(3), rs.getLong(4)};
                TileObject to = TileObject.createQueryTileObject(trObj.layerName, xyz, trObj.gridSetId, trObj.mimeType.getFormat(), trObj.parameters);
                try {
                    blobStore.delete(to);
                }
                catch (StorageException e) {
                    log.debug((Object)("Error while deleting range: " + e.getMessage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.deleteRange(layerId, formatId, parametersId, zoomLevel, bounds, gridSetIdId);
        }
        catch (SQLException e) {
            log.error((Object)("deleteRange failed: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.debug((Object)e.getMessage());
            }
        }
        return true;
    }

    public void expireRange(TileRangeObject trObj, int zoomLevel, long layerId, long formatId, long parametersId, long gridSetIdId) throws SQLException {
        long[] bounds = trObj.rangeBounds[zoomLevel];
        String query = parametersId == -1L ? "UPDATE TILES SET CREATED = -1 WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL" : "UPDATE TILES SET CREATED = -1 WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ?";
        Connection conn = this.getConnection();
        PreparedStatement prep = conn.prepareStatement(query);
        prep.setLong(1, layerId);
        prep.setLong(2, bounds[0]);
        prep.setLong(3, bounds[2]);
        prep.setLong(4, bounds[1]);
        prep.setLong(5, bounds[3]);
        prep.setLong(6, zoomLevel);
        prep.setLong(7, gridSetIdId);
        prep.setLong(8, formatId);
        if (parametersId != -1L) {
            prep.setLong(9, parametersId);
        }
        prep.execute();
    }
}

