/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.Arrays;
import org.geowebcache.storage.StorageObject;

public class TileObject
extends StorageObject {
    public static final String TYPE = "tile";
    long tile_id = -1L;
    byte[] blob;
    long parameters_id = -1L;
    long layer_id = -1L;
    long format_id = -1L;
    long gridset_id = -1L;
    long[] xyz;
    String layer_name;
    String parameters;
    String gridSetId;

    public static TileObject createQueryTileObject(String layerName, long[] xyz, String gridSetId, String format, String parameters) {
        TileObject obj = new TileObject();
        obj.layer_name = layerName;
        obj.xyz = xyz;
        obj.gridSetId = gridSetId;
        obj.blob_format = format;
        obj.parameters = parameters;
        return obj;
    }

    public static TileObject createCompleteTileObject(String layerName, long[] xyz, String gridSetId, String format, String parameters, byte[] blob) {
        TileObject obj = new TileObject();
        obj.layer_name = layerName;
        obj.xyz = xyz;
        obj.gridSetId = gridSetId;
        obj.blob_format = format;
        obj.parameters = parameters;
        if (blob == null) {
            obj.blob_size = -1;
        } else {
            obj.blob_size = blob.length;
            obj.blob = blob;
        }
        obj.created = System.currentTimeMillis();
        return obj;
    }

    private TileObject() {
    }

    public byte[] getBlob() {
        return this.blob;
    }

    public void setBlob(byte[] blob) {
        this.blob_size = blob != null ? blob.length : -1;
        this.blob = blob;
    }

    public long getId() {
        return this.tile_id;
    }

    public void setId(long tile_id) {
        this.tile_id = tile_id;
    }

    public long getFormatId() {
        return this.format_id;
    }

    public void setFormatId(long format_id) {
        this.format_id = format_id;
    }

    public String getGridSetId() {
        return this.gridSetId;
    }

    public long getLayerId() {
        return this.layer_id;
    }

    public void setLayerId(long layer_id) {
        this.layer_id = layer_id;
    }

    public long getParametersId() {
        return this.parameters_id;
    }

    public void setParamtersId(long parameters_id) {
        this.parameters_id = parameters_id;
    }

    public long[] getXYZ() {
        return this.xyz;
    }

    public long getGridSetIdId() {
        return this.gridset_id;
    }

    public void setGridSetIdId(long gridset_id) {
        this.gridset_id = gridset_id;
    }

    public String getLayerName() {
        return this.layer_name;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getType() {
        return TYPE;
    }

    public String toString() {
        return "[" + this.layer_name + "," + this.gridSetId + ",{" + Arrays.toString(this.xyz) + "}]";
    }
}

