/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.seed.SeedRequest;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRangeObject;

public class TruncateTask
extends GWCTask {
    private static Log log = LogFactory.getLog(TruncateTask.class);
    private final SeedRequest req;
    private final TileLayer tl;
    private final StorageBroker storageBroker;
    private static final double[] nullBbox = new double[]{0.0, 0.0, 0.0, 0.0};

    public TruncateTask(StorageBroker sb, SeedRequest req, TileLayer tl) {
        this.storageBroker = sb;
        this.req = req;
        this.tl = tl;
        this.type = 2;
        this.layerName = tl.getName();
    }

    public void doAction() throws GeoWebCacheException {
        String gridSetId = this.req.getGridSetId();
        GridSubset gridSubset = gridSetId == null ? this.tl.getGridSubsetForSRS(this.req.getSRS()) : this.tl.getGridSubset(gridSetId);
        this.runFilterUpdates();
        long[][] rangeBounds = null;
        BoundingBox reqBounds = this.req.getBounds();
        rangeBounds = this.req.getBounds() == null || Arrays.equals(this.req.getBounds().coords, nullBbox) ? gridSubset.getCoverages() : gridSubset.getCoverageIntersections(reqBounds);
        MimeType mimeType = MimeType.createFromFormat(this.req.getMimeFormat());
        int[] metaFactors = this.tl.getMetaTilingFactors();
        if (metaFactors[0] > 1 || metaFactors[1] > 1 && mimeType.supportsTiling()) {
            rangeBounds = gridSubset.expandToMetaFactors(rangeBounds, metaFactors);
        }
        int zoomStart = Math.min(this.req.getZoomStart(), rangeBounds.length - 1);
        int zoomStop = Math.min(this.req.getZoomStop(), rangeBounds.length - 1);
        TileRangeObject trObj = new TileRangeObject(this.layerName, this.req.getGridSetId(), zoomStart, zoomStop, rangeBounds, mimeType, this.req.getParameters());
        try {
            this.storageBroker.delete(trObj);
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
        }
        log.info((Object)"Completed truncate request.");
    }

    private void runFilterUpdates() {
        List<RequestFilter> reqFilters;
        if ((this.req.getFilterUpdate() == null || this.req.getFilterUpdate().booleanValue()) && (reqFilters = this.tl.getRequestFilters()) != null && !reqFilters.isEmpty()) {
            for (RequestFilter reqFilter : reqFilters) {
                if (reqFilter.update(this.tl, this.req.getGridSetId())) {
                    log.info((Object)("Updated request filter " + reqFilter.getName()));
                    continue;
                }
                log.debug((Object)("Request filter " + reqFilter.getName() + " returned false on update."));
            }
        }
    }
}

