/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.grid.XMLGridSubset;
import org.geowebcache.grid.XMLOldGrid;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TileLayer {
    private static Log log = LogFactory.getLog(TileLayer.class);
    protected String name;
    protected LayerMetaInformation layerMetaInfo;
    protected List<String> mimeFormats;
    protected List<FormatModifier> formatModifiers;
    protected List<XMLGridSubset> gridSubsets;
    protected Hashtable<SRS, XMLOldGrid> grids;
    protected List<RequestFilter> requestFilters;
    protected transient List<MimeType> formats;
    protected transient Hashtable<String, GridSubset> subSets;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LayerMetaInformation getMetaInformation() {
        return this.layerMetaInfo;
    }

    public void addGridSet(String gridSetId, GridSubset gridSubset) {
        this.subSets.put(gridSetId, gridSubset);
    }

    public Hashtable<String, GridSubset> getGridSubsets() {
        return this.subSets;
    }

    public void addFormat(String format) throws MimeException {
        MimeType mime = MimeType.createFromFormat(format);
        this.formats.add(mime);
    }

    public abstract boolean initialize(GridSetBroker var1);

    public GridSubset getGridSubsetForSRS(SRS srs) {
        for (GridSubset gridSubset : this.subSets.values()) {
            if (!gridSubset.getSRS().equals(srs)) continue;
            return gridSubset;
        }
        return null;
    }

    public boolean supportsFormat(String strFormat) throws GeoWebCacheException {
        if (strFormat == null) {
            return true;
        }
        for (MimeType mime : this.formats) {
            if (!strFormat.equalsIgnoreCase(mime.getFormat())) continue;
            return true;
        }
        throw new GeoWebCacheException("Format " + strFormat + " is not supported by " + this.getName());
    }

    public abstract ConveyorTile getTile(ConveyorTile var1) throws GeoWebCacheException, IOException, OutsideCoverageException;

    public abstract ConveyorTile getNoncachedTile(ConveyorTile var1) throws GeoWebCacheException;

    public abstract void seedTile(ConveyorTile var1, boolean var2) throws GeoWebCacheException, IOException;

    public abstract ConveyorTile doNonMetatilingRequest(ConveyorTile var1) throws GeoWebCacheException;

    public double[] getResolutions(String gridSetId) throws GeoWebCacheException {
        return this.subSets.get(gridSetId).getResolutions();
    }

    public FormatModifier getFormatModifier(MimeType responseFormat) {
        if (this.formatModifiers == null || this.formatModifiers.size() == 0) {
            return null;
        }
        for (FormatModifier mod : this.formatModifiers) {
            if (mod.getResponseFormat() != responseFormat) continue;
            return mod;
        }
        return null;
    }

    public List<FormatModifier> getFormatModifiers() {
        return this.formatModifiers;
    }

    public void setFormatModifiers(List<FormatModifier> formatModifiers) {
        this.formatModifiers = formatModifiers;
    }

    public abstract String getStyles();

    public abstract int[] getMetaTilingFactors();

    public abstract Boolean isCacheBypassAllowed();

    public abstract void setCacheBypassAllowed(boolean var1);

    public abstract Integer getBackendTimeout();

    public abstract void setBackendTimeout(int var1);

    public abstract List<MimeType> getMimeTypes();

    public abstract MimeType getDefaultMimeType();

    public abstract void destroy();

    public abstract long[] indexFromBounds(String var1, BoundingBox var2) throws BadTileException, GeoWebCacheException;

    public abstract BoundingBox boundsFromIndex(String var1, long[] var2) throws GeoWebCacheException;

    public abstract void acquireLayerLock();

    public abstract void releaseLayerLock();

    public abstract void putTile(ConveyorTile var1) throws GeoWebCacheException;

    public abstract void setExpirationHeader(HttpServletResponse var1, int var2);

    public void mergeWith(TileLayer otherLayer) throws GeoWebCacheException {
        log.warn((Object)("Merging grids, formats and filters of " + this.name));
        if (otherLayer.mimeFormats != null) {
            for (String string : otherLayer.mimeFormats) {
                if (this.supportsFormat(string)) continue;
                this.addFormat(string);
            }
        }
        if (otherLayer.formatModifiers != null) {
            if (this.formatModifiers == null) {
                this.formatModifiers = otherLayer.formatModifiers;
            } else {
                for (FormatModifier formatModifier : otherLayer.formatModifiers) {
                    this.formatModifiers.add(formatModifier);
                }
            }
        }
        if (otherLayer.subSets != null && otherLayer.subSets.size() > 0) {
            for (Map.Entry entry : otherLayer.subSets.entrySet()) {
                this.subSets.put((String)entry.getKey(), (GridSubset)entry.getValue());
            }
        }
        if (otherLayer.requestFilters != null) {
            if (this.requestFilters == null) {
                this.requestFilters = new ArrayList<RequestFilter>();
            }
            Iterator<Object> iter = otherLayer.requestFilters.iterator();
            while (iter.hasNext()) {
                this.requestFilters.add((RequestFilter)iter.next());
            }
        }
        if (this instanceof WMSLayer) {
            WMSLayer thisWMSLayer = (WMSLayer)this;
            thisWMSLayer.mergeWith((WMSLayer)otherLayer);
        }
    }

    public void applyRequestFilters(ConveyorTile convTile) throws RequestFilterException {
        if (this.requestFilters == null) {
            return;
        }
        for (RequestFilter filter : this.requestFilters) {
            filter.apply(convTile);
        }
    }

    public List<RequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    public GridSubset getGridSubset(String gridSetId) {
        return this.subSets.get(gridSetId);
    }
}

