/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;

public class XMLOldGrid {
    private SRS srs = null;
    private BoundingBox dataBounds = null;
    protected BoundingBox gridBounds = null;
    protected Integer zoomStart;
    protected Integer zoomStop;
    protected double[] resolutions = null;

    protected XMLOldGrid() {
    }

    public GridSubset convertToGridSubset(GridSetBroker gridSetBroker) {
        GridSet gridSet;
        if (this.zoomStart == null || this.resolutions != null) {
            this.zoomStart = 0;
        }
        if (this.resolutions != null) {
            this.zoomStop = this.resolutions.length - 1;
        } else if (this.zoomStop == null) {
            this.zoomStop = 30;
        }
        if (this.dataBounds == null) {
            this.dataBounds = this.gridBounds;
        }
        if (this.srs.equals(SRS.getEPSG4326()) && this.gridBounds.equals(BoundingBox.WORLD4326) && this.resolutions == null) {
            gridSet = gridSetBroker.WORLD_EPSG4326;
        } else if (this.srs.equals(SRS.getEPSG3857()) && this.gridBounds.equals(BoundingBox.WORLD3857) && this.resolutions == null) {
            gridSet = gridSetBroker.WORLD_EPSG3857;
        } else if (this.resolutions != null) {
            gridSet = GridSetFactory.createGridSet(this.srs.toString(), this.srs, this.gridBounds, false, this.resolutions, null, null, 2.8E-4, null, 256, 256);
        } else {
            if (this.zoomStop == null) {
                this.zoomStop = 30;
            }
            gridSet = GridSetFactory.createGridSet(this.srs.toString(), this.srs, this.gridBounds, false, this.zoomStop + 1, null, 2.8E-4, 256, 256);
        }
        GridSubset gridSubset = GridSubsetFactory.createGridSubSet(gridSet, this.dataBounds, this.zoomStart, this.zoomStop);
        return gridSubset;
    }
}

