/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.conveyor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;

public class ConveyorTile
extends Conveyor
implements TileResponseReceiver {
    private static Log log = LogFactory.getLog(ConveyorTile.class);
    protected String layerId = null;
    protected String gridSetId = null;
    protected GridSubset gridSubset = null;
    protected TileLayer tileLayer = null;
    TileObject stObj = null;
    String fullParameters;

    public ConveyorTile(StorageBroker sb, String layerId, HttpServletRequest servletReq, HttpServletResponse servletResp) {
        super(sb, servletReq, servletResp);
        this.layerId = layerId;
    }

    public ConveyorTile(StorageBroker sb, String layerId, String gridSetId, long[] tileIndex, MimeType mimeType, String fullParameters, String modifiedParameters, HttpServletRequest servletReq, HttpServletResponse servletResp) {
        super(sb, servletReq, servletResp);
        this.layerId = layerId;
        this.gridSetId = gridSetId;
        long[] idx = new long[3];
        if (tileIndex != null) {
            idx[0] = tileIndex[0];
            idx[1] = tileIndex[1];
            idx[2] = tileIndex[2];
        }
        this.mimeType = mimeType;
        this.fullParameters = fullParameters;
        this.stObj = TileObject.createQueryTileObject(layerId, idx, gridSetId, mimeType.getFormat(), modifiedParameters);
    }

    public String getFullParameters() {
        if (this.fullParameters == null) {
            return "";
        }
        return this.fullParameters;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public TileLayer getLayer() {
        return this.tileLayer;
    }

    public void setTileLayer(TileLayer layer) {
        this.tileLayer = layer;
    }

    public TileLayer getTileLayer() {
        return this.tileLayer;
    }

    public long getTSCreated() {
        return this.stObj.getCreated();
    }

    public int getStatus() {
        return (int)this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMsg = errorMessage;
    }

    public String getParameters() {
        return this.stObj.getParameters();
    }

    public long[] getTileIndex() {
        return this.stObj.getXYZ();
    }

    public synchronized GridSubset getGridSubset() {
        if (this.gridSubset == null) {
            this.gridSubset = this.tileLayer.getGridSubset(this.gridSetId);
        }
        return this.gridSubset;
    }

    public String getGridSetId() {
        return this.gridSetId;
    }

    public void setGridSetId(String gridSetId) {
        this.gridSetId = gridSetId;
    }

    public byte[] getContent() {
        return this.stObj.getBlob();
    }

    public void setContent(byte[] payload) {
        this.stObj.setBlob(payload);
    }

    public boolean persist() throws GeoWebCacheException {
        return this.storageBroker.put(this.stObj);
    }

    public boolean retrieve(long maxAge) throws GeoWebCacheException {
        try {
            boolean ret = this.storageBroker.get(this.stObj);
            if (ret && this.stObj.getCreated() == -1L) {
                ret = false;
            } else if (ret && maxAge > 0L && this.stObj.getCreated() + maxAge < System.currentTimeMillis()) {
                ret = false;
            }
            if (ret) {
                this.setCacheResult(Conveyor.CacheResult.HIT);
            } else {
                this.setCacheResult(Conveyor.CacheResult.MISS);
            }
            return ret;
        }
        catch (StorageException se) {
            log.warn((Object)se.getMessage());
            return false;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ConveyorTile ) ");
        long[] idx = this.stObj.getXYZ();
        if (idx != null && idx.length == 3) {
            str.append("{" + idx[0] + "," + idx[1] + "," + idx[2] + "} ");
        }
        if (this.layerId != null) {
            str.append(this.layerId).append(" ");
        }
        if (this.gridSetId != null) {
            str.append(this.gridSetId).append(" ");
        }
        if (this.mimeType != null) {
            str.append(this.mimeType.getFormat());
        }
        return str.toString();
    }
}

