/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gce.imagemosaic.Granule;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.CRS;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RasterManager {
    private static final Logger LOGGER = Logging.getLogger(RasterManager.class);
    final SoftValueHashMap<String, Granule> granulesCache = new SoftValueHashMap();
    private CoordinateReferenceSystem coverageCRS;
    private GeneralEnvelope coverageEnvelope;
    private GridCoverageFactory coverageFactory;
    private String coverageIdentifier;
    private double[] highestRes;
    private Hints hints;
    private URL inputURL;
    private int numberOfOvervies;
    private double[][] overviewsResolution;
    private MathTransform raster2Model;
    OverviewsController overviewsController;
    private GridEnvelope coverageGridrange;
    OverviewPolicy overviewPolicy;
    DecimationController decimationController;
    ImageMosaicReader parent;
    private String locationAttribute;
    private PathType pathType;
    boolean expandMe;
    SpatialDomainManager spatialDomainManager;
    private final GranuleIndex index = new GranuleIndex();

    public RasterManager(ImageMosaicReader reader) throws DataSourceException {
        ImageMosaicUtils.ensureNonNull("ImageMosaicReader", (Object)reader);
        this.parent = reader;
        this.expandMe = this.parent.expandMe;
        this.inputURL = reader.sourceURL;
        this.locationAttribute = this.parent.locationAttributeName;
        this.coverageIdentifier = reader.getName();
        this.hints = reader.getHints();
        this.coverageEnvelope = reader.getOriginalEnvelope();
        this.coverageGridrange = reader.getOriginalGridRange();
        this.coverageCRS = reader.getCrs();
        this.raster2Model = reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER);
        this.coverageIdentifier = reader.getName();
        this.coverageFactory = reader.getGridCoverageFactory();
        this.pathType = this.parent.pathType;
        this.highestRes = reader.getHighestRes();
        this.numberOfOvervies = reader.getNumberOfOvervies();
        this.overviewsResolution = reader.getOverviewsResolution();
        this.overviewsController = new OverviewsController();
        this.decimationController = new DecimationController();
        try {
            this.spatialDomainManager = new SpatialDomainManager();
        }
        catch (TransformException e) {
            throw new DataSourceException(e);
        }
        catch (FactoryException e) {
            throw new DataSourceException(e);
        }
        this.extractOverviewPolicy();
    }

    private OverviewPolicy extractOverviewPolicy() {
        if (this.hints != null && this.hints.containsKey((Object)Hints.OVERVIEW_POLICY)) {
            this.overviewPolicy = (OverviewPolicy)this.hints.get((Object)Hints.OVERVIEW_POLICY);
        }
        if (this.overviewPolicy == null) {
            this.overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        assert (this.overviewPolicy != null);
        return this.overviewPolicy;
    }

    public Collection<GridCoverage2D> read(GeneralParameterValue[] params) throws IOException {
        RasterLayerRequest request = new RasterLayerRequest(params, this);
        if (request.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request is empty: " + request.toString());
            }
            return Collections.emptyList();
        }
        RasterLayerResponse response = new RasterLayerResponse(request, this);
        GridCoverage2D elem = response.createResponse();
        if (elem != null) {
            return Collections.singletonList(elem);
        }
        return Collections.emptyList();
    }

    public void dispose() {
    }

    List<SimpleFeature> getFeaturesFromIndex(Envelope envelope) throws IOException {
        List<SimpleFeature> features = this.index.findFeatures(envelope);
        if (features != null) {
            return features;
        }
        return Collections.emptyList();
    }

    void getFeaturesFromIndex(Envelope envelope, ItemVisitor visitor) throws IOException {
        this.index.findFeatures(envelope, visitor);
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public String getLocationAttribute() {
        return this.locationAttribute;
    }

    public URL getInputURL() {
        return this.inputURL;
    }

    public String getCoverageIdentifier() {
        return this.coverageIdentifier;
    }

    public Hints getHints() {
        return this.hints;
    }

    public CoordinateReferenceSystem getCoverageCRS() {
        return this.coverageCRS;
    }

    public GeneralEnvelope getCoverageEnvelope() {
        return this.coverageEnvelope;
    }

    public GridCoverageFactory getCoverageFactory() {
        return this.coverageFactory;
    }

    public MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    public GridEnvelope getCoverageGridrange() {
        return this.coverageGridrange;
    }

    class SpatialDomainManager {
        ReferencedEnvelope coverageBBox;
        CoordinateReferenceSystem coverageCRS;
        CoordinateReferenceSystem coverageCRS2D;
        GeneralEnvelope coverageEnvelope = null;
        double[] coverageFullResolution;
        ReferencedEnvelope coverageGeographicBBox;
        CoordinateReferenceSystem coverageGeographicCRS2D;
        MathTransform2D coverageGridToWorld2D;
        Rectangle coverageRasterArea;

        public SpatialDomainManager() throws TransformException, FactoryException {
            this.setBaseParameters();
            this.prepareCoverageSpatialElements();
        }

        private void prepareCoverageSpatialElements() throws TransformException, FactoryException {
            this.coverageGeographicBBox = ImageMosaicUtils.getReferencedEnvelopeFromGeographicBoundingBox((GeographicBoundingBox)new GeographicBoundingBoxImpl((org.opengis.geometry.Envelope)this.coverageEnvelope));
            this.coverageGeographicCRS2D = this.coverageGeographicBBox.getCoordinateReferenceSystem();
            this.coverageCRS2D = CRS.getHorizontalCRS(this.coverageCRS);
            assert (this.coverageCRS2D.getCoordinateSystem().getDimension() == 2);
            if (this.coverageCRS.getCoordinateSystem().getDimension() != 2) {
                MathTransform transform = CRS.findMathTransform(this.coverageCRS, this.coverageCRS2D);
                GeneralEnvelope bbox = CRS.transform(transform, (org.opengis.geometry.Envelope)this.coverageEnvelope);
                bbox.setCoordinateReferenceSystem(this.coverageCRS2D);
                this.coverageBBox = new ReferencedEnvelope(bbox);
            } else {
                this.coverageBBox = new ReferencedEnvelope(this.coverageEnvelope);
            }
        }

        private void setBaseParameters() {
            this.coverageEnvelope = RasterManager.this.getCoverageEnvelope().clone();
            this.coverageRasterArea = (GridEnvelope2D)RasterManager.this.getCoverageGridrange();
            this.coverageCRS = RasterManager.this.getCoverageCRS();
            this.coverageGridToWorld2D = (MathTransform2D)RasterManager.this.getRaster2Model();
            this.coverageFullResolution = new double[2];
            OverviewLevel highestLevel = RasterManager.this.overviewsController.resolutionsLevels.get(0);
            this.coverageFullResolution[0] = highestLevel.resolutionX;
            this.coverageFullResolution[1] = highestLevel.resolutionY;
        }
    }

    class DecimationController {
        void performDecimation(int imageIndex, ImageReadParam readParameters, RasterLayerRequest request) {
            int rasterHeight;
            int rasterWidth;
            ImageMosaicUtils.ensureNonNull("readParameters", readParameters);
            ImageMosaicUtils.ensureNonNull("request", request);
            double[] requestedRes = request.getRequestedResolution();
            if (requestedRes == null) {
                readParameters.setSourceSubsampling(1, 1, 0, 0);
                return;
            }
            double[] selectedRes = new double[2];
            OverviewLevel level = RasterManager.this.overviewsController.resolutionsLevels.get(imageIndex);
            selectedRes[0] = level.resolutionX;
            selectedRes[1] = level.resolutionY;
            if (imageIndex == 0) {
                rasterWidth = RasterManager.this.spatialDomainManager.coverageRasterArea.width;
                rasterHeight = RasterManager.this.spatialDomainManager.coverageRasterArea.height;
            } else {
                rasterWidth = (int)Math.round(RasterManager.this.spatialDomainManager.coverageBBox.getSpan(0) / selectedRes[0]);
                rasterHeight = (int)Math.round(RasterManager.this.spatialDomainManager.coverageBBox.getSpan(1) / selectedRes[1]);
            }
            int subSamplingFactorX = (int)Math.floor(requestedRes[0] / selectedRes[0]);
            int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            while (rasterWidth / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
                --subSamplingFactorX;
            }
            subSamplingFactorX = subSamplingFactorX <= 0 ? 1 : subSamplingFactorX;
            int subSamplingFactorY = (int)Math.floor(requestedRes[1] / selectedRes[1]);
            int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            while (rasterHeight / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
                --subSamplingFactorY;
            }
            subSamplingFactorY = subSamplingFactorY <= 0 ? 1 : subSamplingFactorY;
            readParameters.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
        }
    }

    class OverviewsController {
        final ArrayList<OverviewLevel> resolutionsLevels = new ArrayList();

        public OverviewsController() {
            this.resolutionsLevels.add(new OverviewLevel(1.0, RasterManager.this.highestRes[0], RasterManager.this.highestRes[1], 0));
            if (RasterManager.this.numberOfOvervies > 0) {
                for (int i = 0; i < RasterManager.this.overviewsResolution.length; ++i) {
                    this.resolutionsLevels.add(new OverviewLevel(RasterManager.this.overviewsResolution[i][0] / RasterManager.this.highestRes[0], RasterManager.this.overviewsResolution[i][0], RasterManager.this.overviewsResolution[i][1], i + 1));
                }
                Collections.sort(this.resolutionsLevels);
            }
        }

        int pickOverviewLevel(OverviewPolicy policy, RasterLayerRequest request) {
            double requestedScaleFactor;
            if (this.resolutionsLevels == null || this.resolutionsLevels.size() <= 0) {
                return 0;
            }
            OverviewLevel max = this.resolutionsLevels.get(0);
            double[] requestedRes = request.getRequestedResolution();
            if (requestedRes == null) {
                return 0;
            }
            double reqx = requestedRes[0];
            double reqy = requestedRes[1];
            double requestedScaleFactorX = reqx / max.resolutionX;
            double requestedScaleFactorY = reqy / max.resolutionY;
            boolean leastReduceAxis = !(requestedScaleFactorX <= requestedScaleFactorY);
            double d = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
            if (requestedScaleFactor <= 1.0) {
                return max.imageChoice;
            }
            OverviewLevel min = this.resolutionsLevels.get(this.resolutionsLevels.size() - 1);
            if (requestedScaleFactor >= min.scaleFactor) {
                return min.imageChoice;
            }
            OverviewLevel prev = max;
            int size = this.resolutionsLevels.size();
            for (int i = 1; i < size; ++i) {
                OverviewLevel curr = this.resolutionsLevels.get(i);
                if (curr.scaleFactor == requestedScaleFactor) {
                    return curr.imageChoice;
                }
                if (curr.scaleFactor > requestedScaleFactor || i == size - 1) {
                    if (policy == OverviewPolicy.QUALITY) {
                        return prev.imageChoice;
                    }
                    if (policy == OverviewPolicy.SPEED) {
                        return curr.imageChoice;
                    }
                    if (requestedScaleFactor - prev.scaleFactor < curr.scaleFactor - requestedScaleFactor) {
                        return prev.imageChoice;
                    }
                    return curr.imageChoice;
                }
                prev = curr;
            }
            return max.imageChoice;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverviewLevel
    implements Comparable<OverviewLevel> {
        double scaleFactor;
        double resolutionX;
        double resolutionY;
        int imageChoice;

        public OverviewLevel(double scaleFactor, double resolutionX, double resolutionY, int imageChoice) {
            this.scaleFactor = scaleFactor;
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
            this.imageChoice = imageChoice;
        }

        @Override
        public int compareTo(OverviewLevel other) {
            if (this.scaleFactor > other.scaleFactor) {
                return 1;
            }
            if (this.scaleFactor < other.scaleFactor) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "OverviewLevel[Choice=" + this.imageChoice + ",scaleFactor=" + this.scaleFactor + "]";
        }

        public int hashCode() {
            int hash = Utilities.hash((int)this.imageChoice, (int)31);
            hash = Utilities.hash((double)this.resolutionX, (int)hash);
            hash = Utilities.hash((double)this.resolutionY, (int)hash);
            hash = Utilities.hash((double)this.scaleFactor, (int)hash);
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GranuleIndex {
        private long lastModified = -1L;
        private SoftReference<STRtree> index = new SoftReference<Object>(null);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized SpatialIndex getIndex() throws IOException {
            STRtree tree = null;
            if (RasterManager.this.parent.sourceURL.getProtocol().equals("file")) {
                Object v1;
                STRtree sTRtree;
                FileLock lock = null;
                FileChannel channel = null;
                try {
                    long lastMod;
                    File file = DataUtilities.urlToFile((URL)RasterManager.this.parent.sourceURL);
                    if (file.canWrite()) {
                        channel = new RandomAccessFile(file, "rw").getChannel();
                        lock = channel.lock(0L, Long.MAX_VALUE, true);
                    }
                    if ((lastMod = file.lastModified()) > this.lastModified) {
                        this.index.clear();
                        tree = null;
                    } else {
                        tree = this.index.get();
                    }
                    if (tree == null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Index needs to be recreated...");
                        }
                        this.createIndex();
                        tree = this.index.get();
                        assert (tree != null);
                    } else if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Index does not need to be created...");
                    }
                    sTRtree = tree;
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object v0;
                    Object var9_8 = null;
                    try {
                        try {
                            if (lock != null) {
                                lock.release();
                            }
                            v0 = null;
                        }
                        catch (Throwable e) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                            v0 = null;
                        }
                    }
                    catch (Throwable throwable2) {
                        v0 = null;
                    }
                    Object var12_14 = v0;
                    lock = null;
                    throw throwable;
                }
                try {
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                        v1 = null;
                    }
                    catch (Throwable e) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                        v1 = null;
                    }
                }
                catch (Throwable throwable) {
                    v1 = null;
                }
                Object var12_13 = v1;
                lock = null;
                return sTRtree;
            }
            tree = this.index.get();
            if (tree == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("No index exits and we create a new one.");
                }
                this.createIndex();
                tree = this.index.get();
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index does not need to be created...");
            }
            return tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void createIndex() {
            FeatureCollection features;
            FeatureIterator it;
            block24: {
                ShapefileDataStore tileIndexStore;
                block25: {
                    assert (Thread.holdsLock(this));
                    tileIndexStore = null;
                    it = null;
                    features = null;
                    try {
                        try {
                            String[] typeNames;
                            tileIndexStore = new ShapefileDataStore(RasterManager.this.parent.sourceURL);
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Connected mosaic reader to its data store " + RasterManager.this.parent.sourceURL.toString());
                            }
                            if ((typeNames = tileIndexStore.getTypeNames()).length <= 0) {
                                throw new IllegalArgumentException("Problems when opening the index, no typenames for the schema are defined");
                            }
                            String typeName = typeNames[0];
                            FeatureSource featureSource = tileIndexStore.getFeatureSource(typeName);
                            if (featureSource == null) {
                                throw new NullPointerException("The provided FeatureSource<SimpleFeatureType, SimpleFeature> is null, it's impossible to create an index!");
                            }
                            features = featureSource.getFeatures();
                            if (features == null) {
                                throw new NullPointerException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature> is null, it's impossible to create an index!");
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Index Loaded");
                            }
                            if (!(it = features.features()).hasNext()) {
                                throw new IllegalArgumentException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature>  or empty, it's impossible to create an index!");
                            }
                            STRtree tree = new STRtree();
                            while (it.hasNext()) {
                                SimpleFeature feature = (SimpleFeature)it.next();
                                Geometry g = (Geometry)feature.getDefaultGeometry();
                                tree.insert(g.getEnvelopeInternal(), (Object)feature);
                            }
                            tree.build();
                            this.index = new SoftReference<STRtree>(tree);
                            if (RasterManager.this.parent.sourceURL.getProtocol().equals("file")) {
                                this.lastModified = DataUtilities.urlToFile((URL)RasterManager.this.parent.sourceURL).lastModified();
                            }
                            this.lastModified = new Date().getTime();
                        }
                        catch (Throwable e) {
                            throw new IllegalArgumentException(e);
                        }
                        Object var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        block23: {
                            Object var11_12 = null;
                            try {
                                block22: {
                                    try {
                                        if (tileIndexStore == null) break block22;
                                        tileIndexStore.dispose();
                                    }
                                    catch (Throwable e) {
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                        }
                                        Object var14_17 = null;
                                        tileIndexStore = null;
                                        break block23;
                                    }
                                }
                                Object var14_16 = null;
                                tileIndexStore = null;
                            }
                            catch (Throwable throwable2) {
                                Object var14_18 = null;
                                tileIndexStore = null;
                                throw throwable2;
                            }
                        }
                        if (it == null) throw throwable;
                        if (features == null) throw throwable;
                        features.close(it);
                        throw throwable;
                    }
                    try {}
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        tileIndexStore = null;
                        throw throwable;
                    }
                    try {}
                    catch (Throwable e) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                        Object var14_14 = null;
                        tileIndexStore = null;
                        break block24;
                    }
                    if (tileIndexStore == null) break block25;
                    tileIndexStore.dispose();
                }
                Object var14_13 = null;
                tileIndexStore = null;
            }
            if (it == null) return;
            if (features == null) return;
            features.close(it);
        }

        public List<SimpleFeature> findFeatures(Envelope envelope) throws IOException {
            ImageMosaicUtils.ensureNonNull("envelope", envelope);
            return this.getIndex().query(envelope);
        }

        public void findFeatures(Envelope envelope, ItemVisitor visitor) throws IOException {
            ImageMosaicUtils.ensureNonNull("envelope", envelope);
            ImageMosaicUtils.ensureNonNull("visitor", visitor);
            this.getIndex().query(envelope, visitor);
        }

        public synchronized void dispose() throws IOException {
            this.index.clear();
        }
    }
}

