/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.stream.input.spi.URLImageInputStreamSpi;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.IndexBuilder;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

class ImageMosaicUtils {
    static final AffineTransform CENTER_TO_CORNER = AffineTransform.getTranslateInstance(PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER), PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER));
    static final AffineTransform CORNER_TO_CENTER = AffineTransform.getTranslateInstance(-PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER), -PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER));
    private static final Logger LOGGER = Logging.getLogger((String)ImageMosaicUtils.class.toString());
    static final String DEFAULT_WILCARD = "*.*";
    static final boolean DEFAULT_PATH_BEHAVIOR = false;
    private static ImageInputStreamSpi cachedStreamSPI = new URLImageInputStreamSpi();
    public static final int DEFAULT_PRIORITY = 5;
    public static final String DEFAULT_LOCATION_ATTRIBUTE = "location";
    public static final String DEFAULT_INDEX_NAME = "index";

    ImageMosaicUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createMosaic(String location, String indexName, String wildcard, boolean absolutePath) {
        IndexBuilder.IndexBuilderConfiguration configuration = new IndexBuilder.IndexBuilderConfiguration();
        configuration.setAbsolute(absolutePath);
        configuration.setRootMosaicDirectory(location);
        configuration.setIndexingDirectories(Arrays.asList(location));
        configuration.setIndexName(indexName);
        IndexBuilder indexBuilder = new IndexBuilder(configuration);
        final LinkedList exceptions = new LinkedList();
        try {
            try {
                IndexBuilder.ProcessingEventListener listener = new IndexBuilder.ProcessingEventListener(){

                    public void exceptionOccurred(IndexBuilder.ExceptionEvent event) {
                        Exception t = event.getException();
                        exceptions.add(t);
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                        }
                    }

                    public void getNotification(IndexBuilder.ProcessingEvent event) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(event.getMessage());
                        }
                    }
                };
                indexBuilder.addProcessingEventListener(listener);
                indexBuilder.run();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unable to build mosaic", e);
                boolean bl = false;
                Object var10_10 = null;
                indexBuilder.dispose();
                return bl;
            }
            Object var10_9 = null;
            indexBuilder.dispose();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            indexBuilder.dispose();
            throw throwable;
        }
        return exceptions.size() <= 0;
    }

    static String getMessageFromException(Exception exception) {
        if (exception.getLocalizedMessage() != null) {
            return exception.getLocalizedMessage();
        }
        return exception.getMessage();
    }

    static URL checkSource(Object source) throws MalformedURLException, DataSourceException {
        URL sourceURL = null;
        File sourceFile = null;
        if (source instanceof File) {
            sourceFile = (File)source;
            sourceURL = DataUtilities.fileToURL((File)sourceFile);
            sourceURL = ImageMosaicUtils.checkURLForMosaicQuery(sourceURL);
        } else if (source instanceof URL) {
            sourceURL = ImageMosaicUtils.checkURLForMosaicQuery((URL)source);
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = DataUtilities.urlToFile((URL)sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    sourceURL = ImageMosaicUtils.checkURLForMosaicQuery(sourceURL);
                    source = DataUtilities.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = DataUtilities.fileToURL((File)tempFile);
                sourceFile = tempFile;
            }
        }
        if (sourceFile != null) {
            if (!sourceFile.isDirectory()) {
                sourceURL = DataUtilities.fileToURL((File)sourceFile);
            } else {
                String locationPath = sourceFile.getAbsolutePath();
                String defaultWildcardString = DEFAULT_WILCARD;
                String defaultIndexName = FilenameUtils.getName((String)locationPath);
                File[] properties = sourceFile.listFiles((FilenameFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties")));
                File shapeFile = null;
                for (File propFile : properties) {
                    File shpFile = new File(locationPath, FilenameUtils.getBaseName((String)propFile.getName()) + ".shp");
                    if (!shpFile.exists() || !shpFile.isFile() || !shpFile.canRead() || !propFile.canRead() || !propFile.isFile()) continue;
                    shapeFile = shpFile;
                    break;
                }
                if (shapeFile == null) {
                    ImageMosaicUtils.createMosaic(locationPath, defaultIndexName, DEFAULT_WILCARD, false);
                    shapeFile = new File(locationPath, defaultIndexName + ".shp");
                    File propertiesFile = new File(locationPath, defaultIndexName + ".properties");
                    sourceURL = !(shapeFile.exists() && shapeFile.canRead() && propertiesFile.exists() && propertiesFile.canRead()) ? null : shapeFile.toURI().toURL();
                } else {
                    sourceURL = shapeFile.toURI().toURL();
                }
            }
        }
        return sourceURL;
    }

    static URL checkURLForMosaicQuery(URL sourceURL) {
        block9: {
            String query;
            if (sourceURL.getProtocol().equalsIgnoreCase("file") && (query = sourceURL.getQuery()) != null) {
                String[] tokens = query.split("\\&");
                String locationPath = sourceURL.getPath();
                String indexName = null;
                File sourceDir = new File(locationPath);
                if (!(sourceDir.isDirectory() && sourceDir.exists() && sourceDir.canRead())) {
                    return null;
                }
                String wildcardString = null;
                boolean absolutePath = false;
                for (String token : tokens) {
                    String[] values = token.split("\\=");
                    if (values[0].equalsIgnoreCase("name")) {
                        indexName = values[1];
                        continue;
                    }
                    if (values[0].equalsIgnoreCase("w") || values[0].equalsIgnoreCase("wildcard")) {
                        wildcardString = values[1];
                        continue;
                    }
                    if (!values[0].equalsIgnoreCase("p") && !values[0].equalsIgnoreCase("path")) continue;
                    absolutePath = Boolean.parseBoolean(values[1]);
                }
                File shapeFile = new File(locationPath, indexName + ".shp");
                File propertiesFile = new File(locationPath, indexName + ".properties");
                if (!(shapeFile.exists() && shapeFile.canRead() && shapeFile.isFile() && propertiesFile.exists() && propertiesFile.canRead() && propertiesFile.isFile())) {
                    ImageMosaicUtils.createMosaic(locationPath, indexName != null ? indexName : FilenameUtils.getBaseName((String)locationPath), wildcardString != null ? wildcardString : DEFAULT_WILCARD, absolutePath);
                }
                if (!(shapeFile.exists() && shapeFile.canRead() && shapeFile.isFile() && propertiesFile.exists() && propertiesFile.canRead() && propertiesFile.isFile())) {
                    return null;
                }
                try {
                    return shapeFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block9;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
        return sourceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MosaicConfigurationBean loadPropertiesFile(URL sourceURL, CoordinateReferenceSystem crs, String defaultLocationAttribute) {
        String[] pair;
        InputStream openStream;
        Properties properties;
        MosaicConfigurationBean retValue;
        block25: {
            retValue = new MosaicConfigurationBean();
            properties = new Properties();
            URL propsURL = DataUtilities.changeUrlExt((URL)sourceURL, (String)"properties");
            BufferedInputStream stream = null;
            openStream = null;
            try {
                try {
                    openStream = propsURL.openStream();
                    stream = new BufferedInputStream(openStream);
                    properties.load(stream);
                }
                catch (FileNotFoundException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    MosaicConfigurationBean mosaicConfigurationBean = null;
                    Object var11_9 = null;
                    if (stream != null) {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                    if (openStream != null) {
                        IOUtils.closeQuietly((InputStream)openStream);
                    }
                    return mosaicConfigurationBean;
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    MosaicConfigurationBean mosaicConfigurationBean = null;
                    Object var11_10 = null;
                    if (stream != null) {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                    if (openStream != null) {
                        IOUtils.closeQuietly((InputStream)openStream);
                    }
                    return mosaicConfigurationBean;
                }
                Object var11_8 = null;
                if (stream == null) break block25;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (stream != null) {
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (openStream != null) {
                    IOUtils.closeQuietly((InputStream)openStream);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        if (openStream != null) {
            IOUtils.closeQuietly((InputStream)openStream);
        }
        if (!properties.containsKey("Envelope2D")) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Required key Envelope2D not found.");
            }
            return null;
        }
        String envelope = properties.getProperty("Envelope2D").trim();
        String[] pairs = envelope.split(" ");
        double[][] cornersV = new double[2][2];
        for (int i = 0; i < 2; ++i) {
            pair = pairs[i].split(",");
            cornersV[i][0] = Double.parseDouble(pair[0]);
            cornersV[i][1] = Double.parseDouble(pair[1]);
        }
        GeneralEnvelope originalEnvelope = new GeneralEnvelope(cornersV[0], cornersV[1]);
        originalEnvelope.setCoordinateReferenceSystem(crs);
        retValue.setEnvelope2D(new Envelope2D(originalEnvelope));
        int levelsNumber = Integer.parseInt(properties.getProperty("LevelsNum", "1").trim());
        retValue.setLevelsNum(levelsNumber);
        if (!properties.containsKey("Levels")) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Required key Levels not found.");
            }
            return null;
        }
        String levels = properties.getProperty("Levels").trim();
        pairs = levels.split(" ");
        if (pairs == null || pairs.length != levelsNumber) {
            LOGGER.severe("Levels number is different from the provided number of levels resoltion.");
            return null;
        }
        double[][] resolutions = new double[levelsNumber][2];
        for (int i = 0; i < levelsNumber; ++i) {
            pair = pairs[i].split(",");
            if (pair == null || pair.length != 2) {
                LOGGER.severe("OverviewLevel number is different from the provided number of levels resoltion.");
                return null;
            }
            resolutions[i][0] = Double.parseDouble(pair[0]);
            resolutions[i][1] = Double.parseDouble(pair[1]);
        }
        retValue.setLevels(resolutions);
        if (properties.containsKey("SuggestedSPI")) {
            String suggestedSPI = properties.getProperty("SuggestedSPI").trim();
            retValue.setSuggestedSPI(suggestedSPI);
        }
        if (properties.containsKey("Name")) {
            String coverageName = properties.getProperty("Name").trim();
            retValue.setName(coverageName);
            boolean expandMe = Boolean.valueOf(properties.getProperty("ExpandToRGB", "false").trim());
            retValue.setExpandToRGB(expandMe);
            boolean absolutePath = Boolean.parseBoolean(properties.getProperty("AbsolutePath", Boolean.toString(false)).trim());
            retValue.setAbsolutePath(absolutePath);
            retValue.setLocationAttribute(properties.getProperty("LocationAttribute", DEFAULT_LOCATION_ATTRIBUTE).trim());
            return retValue;
        }
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.severe("Required key Name not found.");
        }
        return null;
    }

    static double getThreshold(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 2: {
                return -32768.0;
            }
            case 5: {
                return -1.7976931348623157E308;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
        }
        return 0.0;
    }

    static ReferencedEnvelope getReferencedEnvelopeFromGeographicBoundingBox(GeographicBoundingBox geographicBBox) {
        ImageMosaicUtils.ensureNonNull("GeographicBoundingBox", geographicBBox);
        return new ReferencedEnvelope(geographicBBox.getEastBoundLongitude(), geographicBBox.getWestBoundLongitude(), geographicBBox.getSouthBoundLatitude(), geographicBBox.getNorthBoundLatitude(), DefaultGeographicCRS.WGS84);
    }

    static RenderedImage makeColorTransparent(Color transparentColor, RenderedImage image) throws IllegalStateException {
        ImageWorker w = new ImageWorker(image);
        if (image.getSampleModel() instanceof MultiPixelPackedSampleModel) {
            w.forceComponentColorModel();
        }
        return w.makeColorTransparent(transparentColor).getRenderedImage();
    }

    static ImageReadParam cloneImageReadParam(ImageReadParam param) {
        ImageReadParam newParam = new ImageReadParam();
        if (param.hasController()) {
            newParam.setController(param.getController());
        }
        newParam.setDestination(param.getDestination());
        if (param.getDestinationType() != null) {
            newParam.setDestinationType(param.getDestinationType());
        }
        newParam.setDestinationBands(param.getDestinationBands());
        newParam.setDestinationOffset(param.getDestinationOffset());
        newParam.setSourceBands(param.getSourceBands());
        newParam.setSourceRegion(param.getSourceRegion());
        if (param.getSourceMaxProgressivePass() != Integer.MAX_VALUE) {
            newParam.setSourceProgressivePasses(param.getSourceMinProgressivePass(), param.getSourceNumProgressivePasses());
        }
        if (param.canSetSourceRenderSize()) {
            newParam.setSourceRenderSize(param.getSourceRenderSize());
        }
        newParam.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
        return newParam;
    }

    static void ensureNonNull(String name, Object object) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)name));
        }
    }

    static IOFileFilter excludeFilters(IOFileFilter inputFilter, IOFileFilter ... filters) {
        IOFileFilter retFilter = inputFilter;
        for (IOFileFilter filter : filters) {
            retFilter = FileFilterUtils.andFileFilter((IOFileFilter)retFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)filter));
        }
        return retFilter;
    }

    static ImageReader getReader(ImageInputStream inStream) {
        ImageMosaicUtils.ensureNonNull("inStream", inStream);
        inStream.mark();
        Iterator<ImageReader> readersIt = ImageIO.getImageReaders(inStream);
        if (!readersIt.hasNext()) {
            return null;
        }
        return readersIt.next();
    }

    static Rectangle getDimension(int imageIndex, ImageInputStream inStream, ImageReader reader) throws IOException {
        ImageMosaicUtils.ensureNonNull("inStream", inStream);
        ImageMosaicUtils.ensureNonNull("reader", reader);
        if (imageIndex < 0) {
            throw new IllegalArgumentException(Errors.format((int)79, (Object)imageIndex));
        }
        inStream.reset();
        reader.setInput(inStream);
        return new Rectangle(0, 0, reader.getWidth(imageIndex), reader.getHeight(imageIndex));
    }

    static ImageInputStream getInputStream(File file) throws IOException {
        ImageInputStream inStream = ImageIO.createImageInputStream(file);
        if (inStream == null) {
            return null;
        }
        return inStream;
    }

    static ImageInputStream getInputStream(URL url) throws IOException {
        ImageInputStream inStream = cachedStreamSPI.createInputStreamInstance(url, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
        if (inStream == null) {
            return null;
        }
        return inStream;
    }

    static boolean checkEmptySourceRegion(ImageReadParam readParameters, Rectangle dimensions) {
        ImageMosaicUtils.ensureNonNull("readDimension", dimensions);
        ImageMosaicUtils.ensureNonNull("readP", readParameters);
        Rectangle sourceRegion = readParameters.getSourceRegion();
        Rectangle.intersect(sourceRegion, dimensions, sourceRegion);
        if (sourceRegion.isEmpty()) {
            return true;
        }
        readParameters.setSourceRegion(sourceRegion);
        return false;
    }

    static boolean checkFileReadable(File file) {
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Checking file:").append(FilenameUtils.getFullPath((String)file.getAbsolutePath())).append("\n");
            builder.append("canRead:").append(file.canRead()).append("\n");
            builder.append("isHidden:").append(file.isHidden()).append("\n");
            builder.append("isFile").append(file.isFile()).append("\n");
            builder.append("canWrite").append(file.canWrite()).append("\n");
            LOGGER.fine(builder.toString());
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    static String checkInputDirectory(String testingDirectory) throws IllegalArgumentException {
        File inDir = new File(testingDirectory);
        if (!inDir.isDirectory() || !inDir.canRead()) {
            LOGGER.severe("Provided input dir does not exist or is not a dir!");
            throw new IllegalArgumentException("Provided input dir does not exist or is not a dir!");
        }
        try {
            testingDirectory = inDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        testingDirectory = FilenameUtils.normalize((String)testingDirectory);
        if (!testingDirectory.endsWith(File.separator)) {
            testingDirectory = testingDirectory + File.separator;
        }
        if (!(inDir = new File(testingDirectory)).isDirectory() || !inDir.canRead()) {
            LOGGER.severe("Provided input dir does not exist or is not a dir!");
            throw new IllegalArgumentException("Provided input dir does not exist or is not a dir!");
        }
        return testingDirectory;
    }

    static boolean checkURLReadable(URL url) {
        try {
            url.openStream().close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static final class MosaicConfigurationBean {
        private boolean absolutePath;
        private boolean expandToRGB;
        private Envelope2D envelope2D;
        private double[][] levels;
        private String name;
        private int levelsNum;
        private String locationAttribute;
        private String suggestedSPI;

        MosaicConfigurationBean() {
        }

        public String getSuggestedSPI() {
            return this.suggestedSPI;
        }

        public void setSuggestedSPI(String suggestedSPI) {
            this.suggestedSPI = suggestedSPI;
        }

        public boolean isAbsolutePath() {
            return this.absolutePath;
        }

        public void setAbsolutePath(boolean absolutePath) {
            this.absolutePath = absolutePath;
        }

        public boolean isExpandToRGB() {
            return this.expandToRGB;
        }

        public void setExpandToRGB(boolean expandToRGB) {
            this.expandToRGB = expandToRGB;
        }

        public Envelope2D getEnvelope2D() {
            return this.envelope2D;
        }

        public void setEnvelope2D(Envelope2D envelope2D) {
            this.envelope2D = envelope2D;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getLevelsNum() {
            return this.levelsNum;
        }

        public void setLevelsNum(int levelsNum) {
            this.levelsNum = levelsNum;
        }

        public double[][] getLevels() {
            return (double[][])this.levels.clone();
        }

        public void setLevels(double[][] levels) {
            this.levels = (double[][])levels.clone();
        }

        public String getLocationAttribute() {
            return this.locationAttribute;
        }

        public void setLocationAttribute(String locationAttribute) {
            this.locationAttribute = locationAttribute;
        }
    }
}

