/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.store.DataPageBinary;
import org.h2.store.FileStore;
import org.h2.util.Cache;
import org.h2.util.Cache2Q;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.FileUtils;

public class PageStore
implements CacheWriter {
    private static final int PAGE_SIZE_MIN = 512;
    private static final int PAGE_SIZE_MAX = 32768;
    private static final int PAGE_SIZE_DEFAULT = 1024;
    private static final int FILE_HEADER_SIZE = 128;
    private static final int READ_VERSION = 0;
    private static final int WRITE_VERSION = 0;
    private Database database;
    private int pageSize;
    private int pageSizeShift;
    private String fileName;
    private FileStore file;
    private String accessMode;
    private int cacheSize;
    private Cache cache;
    private DataPageBinary fileHeader;
    private int systemRootPageId;
    private int freeListRootPageId;
    private int freePageCount;
    private int pageCount;

    public PageStore(Database database, String string, String string2, int n) {
        this.database = database;
        this.fileName = string;
        this.accessMode = string2;
        this.cacheSize = n;
        String string3 = database.getCacheType();
        this.cache = "TQ".equals(string3) ? new Cache2Q(this, this.cacheSize) : new CacheLRU(this, this.cacheSize);
    }

    public void open() throws SQLException {
        try {
            this.fileHeader = new DataPageBinary(this.database, new byte[80]);
            if (FileUtils.exists(this.fileName)) {
                this.file = this.database.openFile(this.fileName, this.accessMode, true);
                this.readHeader();
            } else {
                this.setPageSize(1024);
                this.file = this.database.openFile(this.fileName, this.accessMode, false);
                this.writeHeader();
            }
            this.pageCount = (int)(this.file.length() / (long)this.pageSize);
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    private void readHeader() throws SQLException {
        long l = this.file.length();
        if (l < 128L) {
            throw Message.getSQLException(90030, this.fileName);
        }
        this.database.notifyFileSize(l);
        this.file.seek(48L);
        this.file.readFully(this.fileHeader.getBytes(), 0, 80);
        this.setPageSize(this.fileHeader.readInt());
        int n = this.fileHeader.readByte();
        int n2 = this.fileHeader.readByte();
        if (n2 != 0) {
            throw Message.getSQLException(90048, this.fileName);
        }
        if (n != 0) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, "close");
            }
            this.accessMode = "r";
            this.file = this.database.openFile(this.fileName, this.accessMode, true);
        }
        this.fileHeader.reset();
        this.systemRootPageId = this.fileHeader.readInt();
        this.freeListRootPageId = this.fileHeader.readInt();
        this.freePageCount = this.fileHeader.readInt();
    }

    private void setPageSize(int n) throws SQLException {
        if (n < 512 || n > 32768) {
            throw Message.getSQLException(90030, this.fileName);
        }
        boolean bl = false;
        int n2 = 0;
        for (int i = 1; i <= n; i += i) {
            if (n == i) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw Message.getSQLException(90030, this.fileName);
        }
        this.pageSize = n;
        this.pageSizeShift = n2;
    }

    private void writeHeader() throws SQLException {
        this.fileHeader.reset();
        this.fileHeader.writeInt(this.pageSize);
        this.fileHeader.writeByte((byte)0);
        this.fileHeader.writeByte((byte)0);
        this.fileHeader.writeInt(this.systemRootPageId);
        this.fileHeader.writeInt(this.freeListRootPageId);
        this.fileHeader.writeInt(this.freePageCount);
        this.file.seek(48L);
        this.file.write(this.fileHeader.getBytes(), 0, 80);
        byte[] byArray = new byte[this.pageSize - 128];
        this.file.write(byArray, 0, byArray.length);
    }

    public void close() throws SQLException {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "close");
        }
    }

    public void flushLog() throws SQLException {
    }

    public Trace getTrace() {
        return this.database.getTrace("database");
    }

    public void writeBack(CacheObject cacheObject) throws SQLException {
    }

    public int allocatePage() {
        if (this.freePageCount == 0) {
            return this.pageCount++;
        }
        return 0;
    }

    public DataPageBinary createDataPage() {
        return new DataPageBinary(this.database, new byte[this.pageSize]);
    }

    public DataPageBinary readPage(int n) throws SQLException {
        this.file.seek(n << this.pageSizeShift);
        DataPageBinary dataPageBinary = this.createDataPage();
        this.file.readFully(dataPageBinary.getBytes(), 0, this.pageSize);
        return dataPageBinary;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void writePage(int n, DataPageBinary dataPageBinary) throws SQLException {
        this.file.seek(n << this.pageSizeShift);
        this.file.write(dataPageBinary.getBytes(), 0, this.pageSize);
    }

    public void freePage(int n) {
    }
}

