/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wcs.WCSInfo;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.requests.DescribeRequest;
import org.vfny.geoserver.wcs.requests.WCSRequest;

public class DescribeResponse
implements Response {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses");
    private static final String CURR_VER = "\"1.0.0\"";
    private static final String WCS_URL = "http://www.opengis.net/wcs";
    private static final String WCS_NAMESPACE = new StringBuffer("\n  xmlns=\"").append("http://www.opengis.net/wcs").append("\"").toString();
    private static final String XLINK_URL = "\"http://www.w3.org/1999/xlink\"";
    private static final String XLINK_NAMESPACE = new StringBuffer("\n  xmlns:xlink=").append("\"http://www.w3.org/1999/xlink\"").toString();
    private static final String OGC_URL = "\"http://www.opengis.net/ogc\"";
    private static final String OGC_NAMESPACE = new StringBuffer("\n  xmlns:ogc=").append("\"http://www.opengis.net/ogc\"").toString();
    private static final String GML_URL = "\"http://www.opengis.net/gml\"";
    private static final String GML_NAMESPACE = new StringBuffer("\n  xmlns:gml=").append("\"http://www.opengis.net/gml\"").toString();
    private static final String SCHEMA_URI = "\"http://www.w3.org/2001/XMLSchema-instance\"";
    private static final String XSI_NAMESPACE = new StringBuffer("\n  xmlns:xsi=").append("\"http://www.w3.org/2001/XMLSchema-instance\"").toString();
    private static final String FOOTER = "\n</CoverageDescription>";
    private DescribeRequest request;
    private String xmlResponse = new String();
    protected final DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory(null);
    private WCSInfo wcs;
    protected static final CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory((Hints)new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, CRSAuthorityFactory.class));
    protected final MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
    protected static final CoordinateOperationFactory opFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));

    public DescribeResponse(WCSInfo wcs) {
        this.wcs = wcs;
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request req) throws WcsException {
        DescribeRequest wcsRequest;
        WCSRequest request = (WCSRequest)req;
        if (!(request instanceof DescribeRequest)) {
            throw new WcsException(new StringBuffer("illegal request type, expected DescribeRequest, got ").append((Object)request).toString());
        }
        this.request = wcsRequest = (DescribeRequest)request;
        LOGGER.finer("processing describe request" + (Object)((Object)wcsRequest));
        String outputFormat = wcsRequest.getOutputFormat();
        if (!outputFormat.equalsIgnoreCase("XMLSCHEMA")) {
            throw new WcsException(new StringBuffer("output format: ").append(outputFormat).append(" not ").append("supported by geoserver").toString());
        }
        this.xmlResponse = this.generateCoverages(wcsRequest);
        if (!request.getWCS().getGeoServer().getGlobal().isVerbose()) {
            this.xmlResponse = this.xmlResponse.replaceAll(">\n[ \\t\\n]*", ">");
            this.xmlResponse = this.xmlResponse.replaceAll("\n[ \\t\\n]*", " ");
        }
    }

    public String getContentType(GeoServer gs) {
        return "text/xml; charset=" + gs.getGlobal().getCharset();
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return null;
    }

    public void writeTo(OutputStream out) throws WcsException {
        try {
            Charset encoding = Charset.forName(this.wcs.getGeoServer().getGlobal().getCharset());
            OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
            writer.write(this.xmlResponse);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            throw new WcsException(ex, "", this.getClass().getName());
        }
    }

    private final String generateCoverages(DescribeRequest wcsRequest) throws WcsException {
        ArrayList<String> requestedTypes = wcsRequest.getCoverages();
        StringBuffer tempResponse = new StringBuffer();
        if (requestedTypes.size() == 0) {
            Catalog catalog = wcsRequest.getWCS().getGeoServer().getCatalog();
            requestedTypes = new ArrayList<String>();
            for (CoverageInfo ci : catalog.getCoverages()) {
                requestedTypes.add(ci.getName());
            }
        }
        tempResponse.append("<?xml version=\"1.0\" encoding=\"").append(this.wcs.getGeoServer().getGlobal().getCharset()).append("\"?>").append("\n<CoverageDescription version=").append(CURR_VER).append(" ").toString();
        tempResponse.append(WCS_NAMESPACE);
        tempResponse.append(XLINK_NAMESPACE);
        tempResponse.append(OGC_NAMESPACE);
        tempResponse.append(GML_NAMESPACE);
        tempResponse.append(XSI_NAMESPACE);
        tempResponse.append(" xsi:schemaLocation=\"").append(WCS_URL).append(" ").append("http://schemas.opengis.net/wcs/1.0.0/").append("describeCoverage.xsd\">\n\n");
        tempResponse.append(this.generateSpecifiedCoverages(requestedTypes, wcsRequest.getWCS()));
        tempResponse.append(FOOTER);
        return tempResponse.toString();
    }

    private String generateSpecifiedCoverages(List requestedTypes, WCSInfo gs) throws WcsException {
        String tempResponse = new String();
        String curCoverageName = new String();
        int length = requestedTypes.size();
        Catalog catalog = gs.getGeoServer().getCatalog();
        for (int i = 0; i < length; ++i) {
            curCoverageName = requestedTypes.get(i).toString();
            CoverageInfo meta = catalog.getCoverageByName(curCoverageName);
            if (meta == null) {
                throw new WcsException(new StringBuffer("Coverage ").append(curCoverageName).append(" does ").append("not exist on this server").toString());
            }
            try {
                tempResponse = tempResponse + DescribeResponse.printElement(meta);
                continue;
            }
            catch (Exception e) {
                throw new WcsException(e);
            }
        }
        tempResponse = tempResponse + "\n\n";
        return tempResponse;
    }

    private static String printElement(CoverageInfo cv) throws Exception {
        String tmp;
        StringBuffer tempResponse = new StringBuffer();
        tempResponse.append("\n <CoverageOffering>");
        if (cv.getMetadataLinks() != null) {
            for (MetadataLinkInfo link : cv.getMetadataLinks()) {
                tempResponse.append("\n  <metadataLink about=\"").append(link.getAbout()).append("\" metadataType=\"").append(link.getMetadataType()).append("\"/>");
            }
        }
        if ((tmp = cv.getDescription()) != null && tmp != "") {
            tempResponse.append("\n  <description>").append(tmp).append("</description>");
        }
        if ((tmp = cv.getName()) != null && tmp != "") {
            tempResponse.append("\n  <name>").append(tmp).append("</name>");
        }
        if ((tmp = cv.getTitle()) != null && tmp != "") {
            tempResponse.append("\n  <label>").append(tmp).append("</label>");
        }
        ReferencedEnvelope envelope = cv.getLatLonBoundingBox();
        tempResponse.append("\n  <lonLatEnvelope srsName=\"WGS84(DD)\"").append(">");
        tempResponse.append("\n   <gml:pos>").append(envelope.getLowerCorner().getOrdinate(0)).append(" ").append(envelope.getLowerCorner().getOrdinate(1)).append("</gml:pos>");
        tempResponse.append("\n   <gml:pos>").append(envelope.getUpperCorner().getOrdinate(0)).append(" ").append(envelope.getUpperCorner().getOrdinate(1)).append("</gml:pos>");
        tempResponse.append("\n  </lonLatEnvelope>");
        if (cv.getKeywords() != null && cv.getKeywords().size() > 0) {
            tempResponse.append("\n  <keywords>");
            for (int i = 0; i < cv.getKeywords().size(); ++i) {
                tempResponse.append("\n   <keyword>" + (String)cv.getKeywords().get(i) + "</keyword>");
            }
            tempResponse.append("\n  </keywords>");
        }
        ReferencedEnvelope cvEnvelope = cv.boundingBox();
        tempResponse.append("\n  <domainSet>");
        tempResponse.append("\n   <spatialDomain>");
        String userDefinedCrsIdentifier = cv.getSRS();
        tempResponse.append("\n    <gml:Envelope").append(userDefinedCrsIdentifier != null && userDefinedCrsIdentifier != "" ? new StringBuffer(" srsName=\"").append(userDefinedCrsIdentifier).append("\"").toString() : "").append(">");
        tempResponse.append("\n       <gml:pos>").append(cvEnvelope != null ? new StringBuffer(Double.toString(cvEnvelope.getLowerCorner().getOrdinate(0))).append(" ").append(cvEnvelope.getLowerCorner().getOrdinate(1)).toString() : "").append("</gml:pos>");
        tempResponse.append("\n       <gml:pos>").append(cvEnvelope != null ? new StringBuffer(Double.toString(cvEnvelope.getUpperCorner().getOrdinate(0))).append(" ").append(cvEnvelope.getUpperCorner().getOrdinate(1)).toString() : "").append("</gml:pos>");
        tempResponse.append("\n    </gml:Envelope>");
        GridGeometry grid = cv.getGrid();
        MathTransform gridToCRS = grid.getGridToCRS();
        int gridDimension = gridToCRS != null ? gridToCRS.getSourceDimensions() : 0;
        tempResponse.append("\n    <gml:RectifiedGrid").append(gridToCRS != null ? new StringBuffer(" dimension=\"").append(gridDimension).append("\"").toString() : "").append(">");
        String lowers = "";
        String upers = "";
        for (int r = 0; r < gridDimension; ++r) {
            lowers = lowers + grid.getGridRange().getLow(r) + " ";
            upers = upers + grid.getGridRange().getHigh(r) + " ";
        }
        tempResponse.append("\n       <gml:limits>");
        tempResponse.append("\n         <gml:GridEnvelope>");
        tempResponse.append("\n         <gml:low>" + (cvEnvelope != null ? lowers : "") + "</gml:low>");
        tempResponse.append("\n         <gml:high>" + (cvEnvelope != null ? upers : "") + "</gml:high>");
        tempResponse.append("\n         </gml:GridEnvelope>");
        tempResponse.append("\n       </gml:limits>");
        for (CoverageDimensionInfo dimension : cv.getDimensions()) {
            tempResponse.append("\n       <gml:axisName>" + dimension.getName() + "</gml:axisName>");
        }
        tempResponse.append("\n       <gml:origin>");
        tempResponse.append("\n       <gml:pos>" + (gridToCRS != null ? ((AffineTransform)gridToCRS).getTranslateX() + " " + ((AffineTransform)gridToCRS).getTranslateY() : (cvEnvelope != null ? cvEnvelope.getLowerCorner().getOrdinate(0) + " " + cvEnvelope.getUpperCorner().getOrdinate(1) : "")) + "</gml:pos>");
        tempResponse.append("\n       </gml:origin>");
        tempResponse.append("\n       <gml:offsetVector>" + (gridToCRS != null ? ((AffineTransform)gridToCRS).getScaleX() + " " + ((AffineTransform)gridToCRS).getShearX() : (cvEnvelope != null ? (cvEnvelope.getUpperCorner().getOrdinate(0) - cvEnvelope.getLowerCorner().getOrdinate(0)) / (double)(grid.getGridRange().getHigh(0) - grid.getGridRange().getLow(0)) : 0.0) + " 0.0") + "</gml:offsetVector>");
        tempResponse.append("\n       <gml:offsetVector>" + (gridToCRS != null ? ((AffineTransform)gridToCRS).getShearY() + " " + ((AffineTransform)gridToCRS).getScaleY() : "0.0 " + (cvEnvelope != null ? (cvEnvelope.getLowerCorner().getOrdinate(1) - cvEnvelope.getUpperCorner().getOrdinate(1)) / (double)(grid.getGridRange().getHigh(1) - grid.getGridRange().getLow(1)) : -0.0)) + "</gml:offsetVector>");
        tempResponse.append("\n    </gml:RectifiedGrid>");
        tempResponse.append("\n   </spatialDomain>");
        tempResponse.append("\n  </domainSet>");
        TreeSet<Double> nodataValues = new TreeSet<Double>();
        try {
            if (cv.getDimensions().size() > 0) {
                int numSampleDimensions = cv.getDimensions().size();
                tempResponse.append("\n  <rangeSet>");
                tempResponse.append("\n   <RangeSet>");
                tempResponse.append("\n    <name>" + cv.getName() + "</name>");
                tempResponse.append("\n    <label>" + cv.getTitle() + "</label>");
                tempResponse.append("\n      <axisDescription>");
                tempResponse.append("\n        <AxisDescription>");
                tempResponse.append("\n          <name>Band</name>");
                tempResponse.append("\n          <label>Band</label>");
                tempResponse.append("\n          <values>");
                if (numSampleDimensions == 1) {
                    tempResponse.append("\n            <singleValue>").append("1").append("</singleValue>");
                } else {
                    tempResponse.append("\n            <interval>");
                    tempResponse.append("\n              <min>1</min>");
                    tempResponse.append("\n              <max>" + numSampleDimensions + "</max>");
                    tempResponse.append("\n            </interval>");
                }
                tempResponse.append("\n          </values>");
                tempResponse.append("\n        </AxisDescription>");
                tempResponse.append("\n      </axisDescription>");
                for (CoverageDimensionInfo dim : cv.getDimensions()) {
                    for (Double nullValue : dim.getNullValues()) {
                        if (nodataValues.contains(nullValue)) continue;
                        nodataValues.add(nullValue);
                    }
                }
                tempResponse.append("\n      <nullValues>");
                if (nodataValues.size() > 0) {
                    if (nodataValues.size() == 1) {
                        tempResponse.append("\n        <singleValue>" + (Double)nodataValues.first() + "</singleValue>");
                    } else {
                        tempResponse.append("\n        <interval>");
                        tempResponse.append("\n          <min>" + (Double)nodataValues.first() + "</min>");
                        tempResponse.append("\n          <max>" + (Double)nodataValues.last() + "</max>");
                        tempResponse.append("\n        <interval>");
                    }
                } else {
                    tempResponse.append("\n        <singleValue>0</singleValue>");
                }
                tempResponse.append("\n      </nullValues>");
                tempResponse.append("\n   </RangeSet>");
                tempResponse.append("\n  </rangeSet>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cv.getRequestSRS() != null && cv.getRequestSRS().size() > 0 || cv.getResponseSRS() != null && cv.getResponseSRS().size() > 0) {
            tempResponse.append("\n  <supportedCRSs>");
            if (cv.getResponseSRS() != null && cv.getResponseSRS().size() > 0 && cv.getRequestSRS() != null && cv.getRequestSRS().size() > 0) {
                int i;
                tempResponse.append("\n    <requestResponseCRSs>");
                ArrayList CRSs = new ArrayList();
                for (i = 0; i < cv.getRequestSRS().size(); ++i) {
                    if (CRSs.contains(cv.getRequestSRS().get(i))) continue;
                    CRSs.add(cv.getRequestSRS().get(i));
                }
                for (i = 0; i < cv.getResponseSRS().size(); ++i) {
                    if (CRSs.contains(cv.getResponseSRS().get(i))) continue;
                    CRSs.add(cv.getResponseSRS().get(i));
                }
                for (i = 0; i < CRSs.size(); ++i) {
                    tempResponse.append(CRSs.get(i) + " ");
                }
                tempResponse.append("\n    </requestResponseCRSs>");
            } else {
                if (cv.getRequestSRS() != null && cv.getRequestSRS().size() > 0) {
                    for (int i = 0; i < cv.getRequestSRS().size(); ++i) {
                        tempResponse.append("\n    <requestCRSs>" + (String)cv.getRequestSRS().get(i) + "</requestCRSs>");
                    }
                }
                if (cv.getResponseSRS() != null && cv.getResponseSRS().size() > 0) {
                    for (int i = 0; i < cv.getResponseSRS().size(); ++i) {
                        tempResponse.append("\n    <responseCRSs>" + (String)cv.getResponseSRS().get(i) + "</responseCRSs>");
                    }
                }
            }
            tempResponse.append("\n  </supportedCRSs>");
        }
        String nativeFormat = cv.getNativeFormat() != null && cv.getNativeFormat().equalsIgnoreCase("GEOTIFF") ? "GeoTIFF" : cv.getNativeFormat();
        String supportedFormat = "";
        if (cv.getSupportedFormats() != null && cv.getSupportedFormats().size() > 0) {
            tempResponse.append("\n  <supportedFormats" + (nativeFormat != null && nativeFormat != "" ? " nativeFormat=\"" + nativeFormat + "\"" : "") + ">");
            for (int i = 0; i < cv.getSupportedFormats().size(); ++i) {
                supportedFormat = (String)cv.getSupportedFormats().get(i);
                supportedFormat = supportedFormat.equalsIgnoreCase("GEOTIFF") ? "GeoTIFF" : supportedFormat;
                tempResponse.append("\n    <formats>" + supportedFormat + "</formats>");
            }
            tempResponse.append("\n  </supportedFormats>");
        }
        if (cv.getInterpolationMethods() != null && cv.getInterpolationMethods().size() > 0) {
            tempResponse.append("\n  <supportedInterpolations" + (cv.getDefaultInterpolationMethod() != null && cv.getDefaultInterpolationMethod() != "" ? " default=\"" + cv.getDefaultInterpolationMethod() + "\"" : "") + ">");
            for (int i = 0; i < cv.getInterpolationMethods().size(); ++i) {
                tempResponse.append("\n    <interpolationMethod>" + (String)cv.getInterpolationMethods().get(i) + "</interpolationMethod>");
            }
            tempResponse.append("\n  </supportedInterpolations>");
        }
        tempResponse.append("\n </CoverageOffering>");
        return tempResponse.toString();
    }

    public void abort(ServiceInfo gs) {
    }
}

