/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.requests.readers;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.WCSInfo;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.requests.CoverageRequest;

public class GetCoverageKvpReader
extends KvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests.readers");

    public GetCoverageKvpReader(Map kvPairs, WCSInfo wcs) {
        super(kvPairs, (ServiceInfo)wcs);
    }

    public Request getRequest(HttpServletRequest request) throws ServiceException {
        return this.getCoverageRequest(request);
    }

    public CoverageRequest getCoverageRequest(HttpServletRequest srequest) throws WcsException {
        CoverageRequest currentRequest = new CoverageRequest((WCSInfo)this.serviceConfig);
        currentRequest.setHttpServletRequest(srequest);
        HashMap parameters = new HashMap();
        parameters.putAll(this.kvpPairs);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("setting global request parameters");
        }
        if (this.keyExists("SERVICE")) {
            String service = this.getValue("SERVICE");
            if (!service.trim().toUpperCase().startsWith("WCS")) {
                throw new WcsException("SERVICE parameter is wrong.");
            }
            currentRequest.setService(service);
        } else {
            throw new WcsException("SERVICE parameter is mandatory.");
        }
        parameters.remove("SERVICE");
        if (this.keyExists("VERSION")) {
            String version = this.getValue("VERSION");
            if (!version.equals("1.0.0")) {
                throw new WcsException("VERSION parameter is wrong.");
            }
            currentRequest.setVersion(version);
        } else {
            throw new WcsException("VERSION parameter is mandatory.");
        }
        parameters.remove("VERSION");
        if (this.keyExists("REQUEST")) {
            String request = this.getValue("REQUEST");
            if (!request.equalsIgnoreCase("GetCoverage")) {
                throw new WcsException("REQUEST parameter is wrong.");
            }
            currentRequest.setRequest(request);
        } else {
            throw new WcsException("REQUEST parameter is mandatory.");
        }
        parameters.remove("REQUEST");
        if (!this.keyExists("COVERAGE")) {
            throw new WcsException("COVERAGE parameter is mandatory.");
        }
        currentRequest.setCoverage(this.getValue("COVERAGE"));
        parameters.remove("COVERAGE");
        if (this.keyExists("COVERAGEVERSION")) {
            currentRequest.setCoverageVersion(this.getValue("COVERAGEVERSION"));
            parameters.remove("COVERAGEVERSION");
        }
        if (!this.keyExists("FORMAT")) {
            throw new WcsException("FORMAT parameter is mandatory.");
        }
        currentRequest.setOutputFormat(this.getValue("FORMAT"));
        parameters.remove("FORMAT");
        if (!this.keyExists("CRS")) {
            throw new WcsException("CRS parameter is mandatory.");
        }
        currentRequest.setCRS(this.getValue("CRS"));
        parameters.remove("CRS");
        if (this.keyExists("RESPONSE_CRS")) {
            currentRequest.setResponseCRS(this.getValue("RESPONSE_CRS"));
            parameters.remove("RESPONSE_CRS");
        } else {
            currentRequest.setResponseCRS(this.getValue("CRS"));
        }
        if (!this.keyExists("BBOX")) {
            throw new WcsException("BBOX parameter is mandatory.");
        }
        currentRequest.setEnvelope(this.getValue("BBOX"));
        parameters.remove("BBOX");
        if (this.keyExists("WIDTH") && this.keyExists("HEIGHT")) {
            currentRequest.setGridOrigin(new Double[]{new Double(0.0), new Double(0.0)});
            currentRequest.setGridLow(new Double[]{new Double(0.0), new Double(0.0)});
            currentRequest.setGridHigh(new Double[]{Double.valueOf(this.getValue("WIDTH")), Double.valueOf(this.getValue("HEIGHT"))});
            parameters.remove("WIDTH");
            parameters.remove("HEIGHT");
        } else if (currentRequest.getEnvelope() != null && this.keyExists("RESX") && this.keyExists("RESY")) {
            Envelope envelope = currentRequest.getEnvelope();
            double envWidth = Math.abs(envelope.getMaxX() - envelope.getMinX());
            double envHeight = Math.abs(envelope.getMaxY() - envelope.getMinY());
            double width = envWidth / Math.abs(Double.parseDouble(this.getValue("RESX")));
            double height = envHeight / Math.abs(Double.parseDouble(this.getValue("RESY")));
            if (width >= 1.0 && height >= 1.0) {
                currentRequest.setGridOrigin(new Double[]{new Double(0.0), new Double(0.0)});
                currentRequest.setGridLow(new Double[]{new Double(0.0), new Double(0.0)});
                currentRequest.setGridHigh(new Double[]{new Double(width), new Double(height)});
            }
            parameters.remove("RESX");
            parameters.remove("RESY");
        }
        if (this.keyExists("INTERPOLATION")) {
            currentRequest.setInterpolation(this.getValue("INTERPOLATION"));
            parameters.remove("INTERPOLATION");
        }
        currentRequest.setParameters(parameters);
        return currentRequest;
    }

    protected String getValue(String key) {
        String value = super.getValue(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }
}

