/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.DecoratingFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.data.FeatureSource;
import org.geotools.factory.Hints;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.util.ProgressListener;

public class SecuredFeatureTypeInfo
extends DecoratingFeatureTypeInfo {
    SecureCatalogImpl.WrapperPolicy policy;

    public SecuredFeatureTypeInfo(FeatureTypeInfo info, SecureCatalogImpl.WrapperPolicy policy) {
        super(info);
        this.policy = policy;
    }

    public FeatureSource getFeatureSource(ProgressListener listener, Hints hints) throws IOException {
        FeatureSource<? extends FeatureType, ? extends Feature> fs = ((FeatureTypeInfo)this.delegate).getFeatureSource(listener, hints);
        if (this.policy == SecureCatalogImpl.WrapperPolicy.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return (FeatureSource)SecuredObjects.secure(fs, this.policy);
    }

    public DataStoreInfo getStore() {
        return (DataStoreInfo)SecuredObjects.secure(((FeatureTypeInfo)this.delegate).getStore(), this.policy);
    }
}

