/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.geoserver.security.AccessMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecureTreeNode {
    static final Set<String> EVERYBODY = Collections.singleton("*");
    static final String ROOT_ROLE = "ROLE_ADMINISTRATOR";
    Map<String, SecureTreeNode> children = new HashMap<String, SecureTreeNode>();
    SecureTreeNode parent;
    Map<AccessMode, Set<String>> authorizedRoles = new HashMap<AccessMode, Set<String>>();

    private SecureTreeNode(SecureTreeNode parent) {
        this.parent = parent;
    }

    SecureTreeNode() {
        for (AccessMode mode : AccessMode.values()) {
            this.authorizedRoles.put(mode, EVERYBODY);
        }
    }

    SecureTreeNode getChild(String name) {
        return this.children.get(name);
    }

    SecureTreeNode addChild(String name) {
        if (this.getChild(name) != null) {
            throw new IllegalArgumentException("This pathElement " + name + " is already among my children");
        }
        SecureTreeNode child = new SecureTreeNode(this);
        this.children.put(name, child);
        return child;
    }

    boolean canAccess(Authentication user, AccessMode mode) {
        Set<String> roles = this.getAuthorizedRoles(mode);
        if (roles == null) {
            return this.parent.canAccess(user, mode);
        }
        if (((Object)roles).equals(EVERYBODY)) {
            return true;
        }
        if (user == null || user.getAuthorities() == null) {
            return false;
        }
        for (GrantedAuthority authority : user.getAuthorities()) {
            String userRole = authority.getAuthority();
            if (!roles.contains(userRole) && !ROOT_ROLE.equals(userRole)) continue;
            return true;
        }
        return false;
    }

    Set<String> getAuthorizedRoles(AccessMode mode) {
        return this.authorizedRoles.get((Object)mode);
    }

    void setAuthorizedRoles(AccessMode mode, Set<String> roles) {
        this.authorizedRoles.put(mode, roles);
    }

    SecureTreeNode getDeepestNode(String[] pathElements) {
        SecureTreeNode curr = this;
        for (int i = 0; i < pathElements.length; ++i) {
            SecureTreeNode next = curr.getChild(pathElements[i]);
            if (next == null) {
                return curr;
            }
            curr = next;
        }
        return curr;
    }
}

