/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.adapters;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.ows.HttpServletRequestAware;
import org.geoserver.ows.KvpRequestReader;

public class KvpRequestReaderAdapter
extends KvpRequestReader
implements HttpServletRequestAware {
    Class delegateClass;
    ServiceInfo service;
    HttpServletRequest request;

    public KvpRequestReaderAdapter(Class requestBean, Class delegateClass, ServiceInfo service) {
        super(requestBean);
        this.delegateClass = delegateClass;
        this.service = service;
    }

    public void setHttpRequest(HttpServletRequest request) {
        this.request = request;
    }

    public Object createRequest() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        Enumeration pnames = this.request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = this.request.getParameter(paramName);
            kvp.put(paramName.toUpperCase(), paramValue);
        }
        Class<?> clazz = GeoServerImpl.unwrap(this.service).getClass();
        Constructor constructor = null;
        while (clazz != null && constructor == null) {
            try {
                constructor = this.delegateClass.getConstructor(Map.class, clazz);
            }
            catch (NoSuchMethodException e) {
                Class<?>[] classes;
                for (Class<?> c : classes = clazz.getInterfaces()) {
                    try {
                        constructor = this.delegateClass.getConstructor(Map.class, c);
                    }
                    catch (NoSuchMethodException e2) {
                        // empty catch block
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (constructor == null) {
            throw new IllegalStateException("No appropriate constructor");
        }
        org.vfny.geoserver.util.requests.readers.KvpRequestReader delegate = (org.vfny.geoserver.util.requests.readers.KvpRequestReader)constructor.newInstance(kvp, this.service);
        return delegate.getRequest(this.request);
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        return request;
    }
}

