/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.Subtract;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLDialect {
    protected static final Logger LOGGER = Logging.getLogger(SQLDialect.class);
    public static FilterCapabilities BASE_DBMS_CAPABILITIES = new FilterCapabilities(){
        {
            this.addAll(FilterCapabilities.LOGICAL_OPENGIS);
            this.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
            this.addType(Add.class);
            this.addType(Subtract.class);
            this.addType(Multiply.class);
            this.addType(Divide.class);
            this.addType(PropertyIsNull.class);
            this.addType(PropertyIsBetween.class);
            this.addType(Id.class);
            this.addType(IncludeFilter.class);
            this.addType(ExcludeFilter.class);
            this.addType(PropertyIsLike.class);
        }
    };
    protected JDBCDataStore dataStore;

    protected SQLDialect(JDBCDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void initializeConnection(Connection cx) throws SQLException {
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return true;
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        return null;
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        mappings.put(new Integer(12), String.class);
        mappings.put(new Integer(1), String.class);
        mappings.put(new Integer(-1), String.class);
        mappings.put(new Integer(-7), Boolean.class);
        mappings.put(new Integer(16), Boolean.class);
        mappings.put(new Integer(-6), Short.class);
        mappings.put(new Integer(5), Short.class);
        mappings.put(new Integer(4), Integer.class);
        mappings.put(new Integer(-5), Long.class);
        mappings.put(new Integer(7), Float.class);
        mappings.put(new Integer(6), Double.class);
        mappings.put(new Integer(8), Double.class);
        mappings.put(new Integer(3), BigDecimal.class);
        mappings.put(new Integer(2), BigDecimal.class);
        mappings.put(new Integer(91), Date.class);
        mappings.put(new Integer(92), Time.class);
        mappings.put(new Integer(93), Timestamp.class);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        mappings.put(String.class, new Integer(12));
        mappings.put(Boolean.class, new Integer(16));
        mappings.put(Short.class, new Integer(5));
        mappings.put(Integer.class, new Integer(4));
        mappings.put(Long.class, new Integer(-5));
        mappings.put(Float.class, new Integer(7));
        mappings.put(Double.class, new Integer(8));
        mappings.put(BigDecimal.class, new Integer(2));
        mappings.put(Date.class, new Integer(91));
        mappings.put(Time.class, new Integer(92));
        mappings.put(java.util.Date.class, new Integer(93));
        mappings.put(Timestamp.class, new Integer(93));
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
    }

    public void registerAggregateFunctions(Map<Class<? extends FeatureVisitor>, String> aggregates) {
        aggregates.put(CountVisitor.class, "count");
        aggregates.put(MinVisitor.class, "min");
        aggregates.put(MaxVisitor.class, "max");
        aggregates.put(SumVisitor.class, "sum");
    }

    public String getNameEscape() {
        return "\"";
    }

    protected final String ne() {
        return this.getNameEscape();
    }

    public void encodeColumnName(String raw, StringBuffer sql) {
        sql.append(this.ne()).append(raw).append(this.ne());
    }

    public void encodeColumnType(String sqlTypeName, StringBuffer sql) {
        sql.append(sqlTypeName);
    }

    public void encodeColumnAlias(String raw, StringBuffer sql) {
        sql.append(" as ");
        this.encodeColumnName(raw, sql);
    }

    public void encodeTableAlias(String raw, StringBuffer sql) {
        sql.append(" as ");
        this.encodeColumnName(raw, sql);
    }

    public void encodeTableName(String raw, StringBuffer sql) {
        sql.append(this.ne()).append(raw).append(this.ne());
    }

    public void encodeSchemaName(String raw, StringBuffer sql) {
        sql.append(this.ne()).append(raw).append(this.ne());
    }

    public String getGeometryTypeName(Integer type) {
        return null;
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return null;
    }

    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        try {
            return CRS.decode("EPSG:" + srid);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Could not decode " + srid + " using the built-in EPSG database");
            }
            return null;
        }
    }

    public abstract void encodeGeometryEnvelope(String var1, String var2, StringBuffer var3);

    public abstract Envelope decodeGeometryEnvelope(ResultSet var1, int var2, Connection var3) throws SQLException, IOException;

    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, StringBuffer sql) {
        this.encodeColumnName(gatt.getLocalName(), sql);
    }

    public void encodeGeometryColumnGeneralized(GeometryDescriptor gatt, int srid, StringBuffer sql, Double distance) {
        throw new UnsupportedOperationException("Geometry generalization not supported");
    }

    public void encodeGeometryColumnSimplified(GeometryDescriptor gatt, int srid, StringBuffer sql, Double distance) {
        throw new UnsupportedOperationException("Geometry simplification not supported");
    }

    public abstract Geometry decodeGeometryValue(GeometryDescriptor var1, ResultSet var2, String var3, GeometryFactory var4, Connection var5) throws IOException, SQLException;

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        String columnName = rs.getMetaData().getColumnName(column);
        return this.decodeGeometryValue(descriptor, rs, columnName, factory, cx);
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(column, sql);
        sql.append(" INTEGER PRIMARY KEY");
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
    }

    public void encodePostCreateTable(String tableName, StringBuffer sql) {
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
    }

    public void postCreateAttribute(AttributeDescriptor att, ResultSet columnMetadata, String tableName, String schemaName, Connection cx) throws SQLException {
    }

    public void postCreateFeatureType(SimpleFeatureType featureType, DatabaseMetaData metadata, String schemaName, Connection cx) throws SQLException {
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return false;
    }

    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return null;
    }

    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return null;
    }

    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return null;
    }

    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        return null;
    }

    public boolean isLimitOffsetSupported() {
        return false;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        throw new UnsupportedOperationException("Ovveride this method when isLimitOffsetSupported returns true");
    }

    protected void addSupportedHints(Set<Hints.Key> hints) {
    }
}

