/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedFilterToSQL
extends FilterToSQL {
    protected List<Object> literalValues = new ArrayList<Object>();
    protected List<Class> literalTypes = new ArrayList<Class>();
    protected List<Integer> SRIDs = new ArrayList<Integer>();
    protected PreparedStatementSQLDialect dialect;
    boolean prepareEnabled = true;

    public PreparedFilterToSQL() {
        this.dialect = null;
    }

    public PreparedFilterToSQL(PreparedStatementSQLDialect dialect) {
        this.dialect = dialect;
    }

    public boolean isPrepareEnabled() {
        return this.prepareEnabled;
    }

    public void setPrepareEnabled(boolean prepareEnabled) {
        this.prepareEnabled = prepareEnabled;
    }

    public PreparedFilterToSQL(Writer out) {
        super(out);
    }

    @Override
    public Object visit(Literal expression, Object context) throws RuntimeException {
        if (!this.prepareEnabled) {
            return super.visit(expression, context);
        }
        Object literalValue = this.evaluateLiteral(expression, context instanceof Class ? (Class)context : null);
        this.literalValues.add(literalValue);
        this.SRIDs.add(this.currentSRID);
        Class clazz = null;
        if (literalValue != null) {
            clazz = literalValue.getClass();
        } else if (context instanceof Class) {
            clazz = (Class)context;
        }
        this.literalTypes.add(clazz);
        try {
            if (literalValue == null || this.dialect == null) {
                this.out.write("?");
            } else {
                StringBuffer sb = new StringBuffer();
                if (Geometry.class.isAssignableFrom(literalValue.getClass())) {
                    int srid = this.currentSRID != null ? this.currentSRID : -1;
                    this.dialect.prepareGeometryValue((Geometry)literalValue, srid, Geometry.class, sb);
                } else if (this.encodingFunction) {
                    this.dialect.prepareFunctionArgument(clazz, sb);
                } else {
                    sb.append("?");
                }
                this.out.write(sb.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return context;
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        if (this.mapper == null) {
            throw new RuntimeException("Must set a fid mapper before trying to encode FIDFilters");
        }
        Set ids = filter.getIdentifiers();
        String[] colNames = new String[this.mapper.getColumnCount()];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = this.mapper.getColumnName(i);
        }
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            try {
                Identifier id = (Identifier)i.next();
                Object[] attValues = this.mapper.getPKAttributes(id.toString());
                this.out.write("(");
                for (int j = 0; j < attValues.length; ++j) {
                    this.out.write(this.escapeName(colNames[j]));
                    this.out.write(" = ");
                    this.out.write(63);
                    this.literalValues.add(attValues[j]);
                    this.SRIDs.add(-1);
                    this.literalTypes.add(attValues[j] != null ? attValues[j].getClass() : null);
                    if (j >= attValues.length - 1) continue;
                    this.out.write(" AND ");
                }
                this.out.write(")");
                if (!i.hasNext()) continue;
                this.out.write(" OR ");
            }
            catch (IOException e) {
                throw new RuntimeException("io problem writing filter", e);
            }
        }
        return extraData;
    }

    public List<Object> getLiteralValues() {
        return this.literalValues;
    }

    public List<Class> getLiteralTypes() {
        return this.literalTypes;
    }

    public List<Integer> getSRIDs() {
        return this.SRIDs;
    }
}

