/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentState;
import org.geotools.factory.Hints;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCUpdateFeatureWriter;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCInsertFeatureWriter
extends JDBCFeatureReader
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    JDBCFeatureReader.ResultSetFeature last;

    public JDBCInsertFeatureWriter(String sql, Connection cx, JDBCFeatureSource featureSource, Hints hints) throws SQLException, IOException {
        super(sql, cx, featureSource, featureSource.getSchema(), hints);
        this.last = new JDBCFeatureReader.ResultSetFeature(this, this.rs, cx);
    }

    public JDBCInsertFeatureWriter(PreparedStatement ps, Connection cx, JDBCFeatureSource featureSource, Hints hints) throws SQLException, IOException {
        super(ps, cx, featureSource, featureSource.getSchema(), hints);
        this.last = new JDBCFeatureReader.ResultSetFeature(this, this.rs, ps.getConnection());
    }

    public JDBCInsertFeatureWriter(JDBCUpdateFeatureWriter other) {
        super(other);
        this.last = other.last;
    }

    @Override
    public boolean hasNext() throws IOException {
        return false;
    }

    @Override
    public SimpleFeature next() throws IOException {
        this.last.init(null);
        return this.last;
    }

    @Override
    public void remove() throws IOException {
    }

    @Override
    public void write() throws IOException {
        try {
            this.dataStore.insert(this.last, this.featureType, this.st.getConnection());
            String fid = (String)this.last.getUserData().get("fid");
            this.last.setID(fid);
            ContentEntry entry = this.featureSource.getEntry();
            ContentState state = entry.getState(this.tx);
            state.fireFeatureAdded((FeatureSource)((Object)this.featureSource), (Feature)this.last);
        }
        catch (SQLException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.last != null) {
            this.last.close();
            this.last = null;
        }
    }
}

