/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.util.Collections;
import java.util.Map;

public class JDBCDataStoreConfig {
    public static final String FID_GEN_INSERT_NULL = "INSERT_NULL";
    public static final String FID_GEN_MANUAL_INC = "MANUAL_INC";
    public static final String DEFAULT_FID_GEN_KEY = "DEFAULT_GEN";
    public static final String DEFAULT_FID_GEN = "INSERT_NULL";
    private final String namespace;
    private final String databaseSchemaName;
    protected final long typeHandlerCacheTimout;

    public JDBCDataStoreConfig() {
        this(null, null, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    public JDBCDataStoreConfig(String namespace, String databaseSchemaName, Map fidColumnOverrideMap, Map fidGenerationMap) {
        this(namespace, databaseSchemaName, Long.MAX_VALUE);
    }

    public JDBCDataStoreConfig(String namespace, String databaseSchemaName, long typeHandlerCacheTimeout) {
        this.namespace = namespace;
        this.databaseSchemaName = databaseSchemaName == null || databaseSchemaName.equals("") ? null : databaseSchemaName;
        this.typeHandlerCacheTimout = typeHandlerCacheTimeout;
    }

    public static JDBCDataStoreConfig createWithNameSpaceAndSchemaName(String namespace, String schemaName) {
        return new JDBCDataStoreConfig(namespace, schemaName, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    public static JDBCDataStoreConfig createWithSchemaNameAndFIDGenMap(String schemaName, Map fidGenerationMap) {
        return new JDBCDataStoreConfig(null, schemaName, Collections.EMPTY_MAP, fidGenerationMap);
    }

    public String getDatabaseSchemaName() {
        return this.databaseSchemaName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public long getTypeHandlerTimeout() {
        return this.typeHandlerCacheTimout;
    }
}

