/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.filechooser.FileSystemView;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.wicket.browser.FileBreadcrumbs;
import org.geoserver.web.wicket.browser.FileDataView;
import org.geoserver.web.wicket.browser.FileProvider;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class GeoServerFileChooser
extends Panel {
    FileBreadcrumbs breadcrumbs;
    FileDataView fileTable;
    IModel file;

    public GeoServerFileChooser(String id, IModel file) {
        super(id, file);
        this.file = file;
        ArrayList<File> roots = new ArrayList<File>(Arrays.asList(File.listRoots()));
        Collections.sort(roots);
        File dataDirectory = GeoserverDataDirectory.getGeoserverDataDirectory();
        roots.add(0, dataDirectory);
        File selection = (File)file.getObject();
        File selectionRoot = null;
        if (selection != null && selection.exists()) {
            for (File root : roots) {
                if (!this.isSubfile(root, selection.getAbsoluteFile())) continue;
                selectionRoot = root;
            }
            if (selectionRoot == null) {
                selectionRoot = dataDirectory;
                file = new Model((Serializable)selectionRoot);
            }
        } else {
            selectionRoot = dataDirectory;
            file = new Model((Serializable)selectionRoot);
        }
        final DropDownChoice choice = new DropDownChoice("roots", (IModel)new Model((Serializable)selectionRoot), (IModel)new Model(roots), (IChoiceRenderer)new FileRenderer());
        choice.add((IBehavior)new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                File selection = (File)choice.getModelObject();
                GeoServerFileChooser.this.breadcrumbs.setRootFile(selection);
                GeoServerFileChooser.this.updateFileBrowser(selection, target);
            }
        });
        choice.setOutputMarkupId(true);
        this.add((Component)choice);
        this.breadcrumbs = new FileBreadcrumbs("breadcrumbs", (IModel)new Model((Serializable)selectionRoot), file){

            protected void pathItemClicked(File file, AjaxRequestTarget target) {
                GeoServerFileChooser.this.updateFileBrowser(file, target);
            }
        };
        this.breadcrumbs.setOutputMarkupId(true);
        this.add((Component)this.breadcrumbs);
        this.fileTable = new FileDataView("fileTable", new FileProvider(file)){

            protected void linkNameClicked(File file, AjaxRequestTarget target) {
                GeoServerFileChooser.this.updateFileBrowser(file, target);
            }
        };
        this.fileTable.setOutputMarkupId(true);
        this.add((Component)this.fileTable);
    }

    void updateFileBrowser(File file, AjaxRequestTarget target) {
        if (file.isDirectory()) {
            this.file.setObject((Object)file);
            this.fileTable.getProvider().setDirectory((IModel)new Model((Serializable)file));
            this.breadcrumbs.setSelection(file);
            target.addComponent((Component)this.fileTable);
            target.addComponent((Component)this.breadcrumbs);
        }
    }

    private boolean isSubfile(File root, File selection) {
        if (selection == null || "".equals(selection.getPath())) {
            return false;
        }
        if (selection.equals(root)) {
            return true;
        }
        return this.isSubfile(root, selection.getParentFile());
    }

    public void setFilter(IModel fileFilter) {
        this.fileTable.provider.setFileFilter(fileFilter);
    }

    class FileRenderer
    implements IChoiceRenderer {
        FileRenderer() {
        }

        public Object getDisplayValue(Object o) {
            File f = (File)o;
            return FileSystemView.getFileSystemView().getSystemDisplayName(f);
        }

        public String getIdValue(Object o, int count) {
            File f = (File)o;
            return "" + count;
        }
    }
}

