/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class GeoServerDialog
extends Panel {
    ModalWindow window = new ModalWindow("dialog");
    DialogDelegate delegate;

    public GeoServerDialog(String id) {
        super(id);
        this.add((Component)this.window);
    }

    public void setTitle(IModel title) {
        this.window.setTitle(title);
    }

    public void showOkCancel(AjaxRequestTarget target, final DialogDelegate delegate) {
        this.window.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                return new ContentsPage(delegate.getContents("userPanel"));
            }
        });
        this.window.setCloseButtonCallback(new ModalWindow.CloseButtonCallback(){

            public boolean onCloseButtonClicked(AjaxRequestTarget target) {
                return delegate.onCancel(target);
            }
        });
        this.window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                delegate.onClose(target);
            }
        });
        this.delegate = delegate;
        this.window.show(target);
    }

    Component sumbitLink(Component contents) {
        AjaxSubmitLink link = new AjaxSubmitLink("submit"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                if (GeoServerDialog.this.delegate.onSubmit(target, (Component)this.getModelObject())) {
                    GeoServerDialog.this.window.close(target);
                    GeoServerDialog.this.delegate = null;
                }
            }
        };
        link.setModel((IModel)new Model((Serializable)contents));
        return link;
    }

    Component cancelLink() {
        return new AjaxLink("cancel"){

            public void onClick(AjaxRequestTarget target) {
                if (GeoServerDialog.this.delegate.onCancel(target)) {
                    GeoServerDialog.this.window.close(target);
                    GeoServerDialog.this.delegate = null;
                }
            }
        };
    }

    public static abstract class DialogDelegate
    implements Serializable {
        protected abstract Component getContents(String var1);

        public void onClose(AjaxRequestTarget target) {
        }

        protected abstract boolean onSubmit(AjaxRequestTarget var1, Component var2);

        protected boolean onCancel(AjaxRequestTarget target) {
            return true;
        }
    }

    protected class ContentsPage
    extends WebPage {
        public ContentsPage(Component contents) {
            Form form = new Form("form");
            this.add((Component)form);
            form.add(contents);
            form.add(GeoServerDialog.this.sumbitLink(contents));
            form.add(GeoServerDialog.this.cancelLink());
        }
    }
}

