/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.geotools.util.Converters;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class FileExistsValidator
extends AbstractValidator {
    protected void onValidate(IValidatable validatable) {
        String uriSpec = (String)Converters.convert((Object)validatable.getValue(), String.class);
        try {
            URI uri = new URI(uriSpec);
            if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
                return;
            }
            String path = uri.getPath();
            if (path != null && new File(path).exists()) {
                return;
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        File relFile = GeoserverDataDirectory.findDataFile((String)uriSpec);
        if (relFile == null || !relFile.exists()) {
            this.error(validatable, "FileExistsValidator.fileNotFoundError", Collections.singletonMap("file", uriSpec));
        }
    }
}

