/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.services;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.config.ServiceInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geoserver.web.wicket.LiveCollectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseServiceAdminPage<T extends ServiceInfo>
extends GeoServerSecuredPage {
    public BaseServiceAdminPage() {
        LoadableDetachableModel infoModel = new LoadableDetachableModel(){

            public Object load() {
                return BaseServiceAdminPage.this.getGeoServer().getService(BaseServiceAdminPage.this.getServiceClass());
            }
        };
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)infoModel));
        this.add((Component)form);
        form.add((Component)new Label("service.enabled", (IModel)new StringResourceModel("service.enabled", (Component)this, null, new Object[]{this.getServiceName()})));
        form.add((Component)new TextField("maintainer"));
        TextField onlineResource = new TextField("onlineResource");
        onlineResource.add((IValidator)new UrlValidator());
        form.add((Component)onlineResource);
        form.add((Component)new CheckBox("enabled"));
        form.add((Component)new CheckBox("citeCompliant"));
        form.add((Component)new TextField("title"));
        form.add((Component)new TextArea("abstract"));
        form.add((Component)new KeywordsEditor("keywords", LiveCollectionModel.list((IModel)new PropertyModel((Object)infoModel, "keywords"))));
        form.add((Component)new TextField("fees"));
        form.add((Component)new TextField("accessConstraints"));
        this.build((IModel)infoModel, form);
        SubmitLink submit = new SubmitLink("submit", (IModel)new StringResourceModel("save", (Component)null, null), (IModel)infoModel){
            final /* synthetic */ IModel val$infoModel;
            {
                this.val$infoModel = iModel;
                super(x0, x1);
            }

            public void onSubmit() {
                BaseServiceAdminPage.this.handleSubmit((ServiceInfo)this.val$infoModel.getObject());
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add((Component)submit);
        Button cancel = new Button("cancel", (IModel)new StringResourceModel("cancel", (Component)null, null)){

            public void onSubmit() {
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add((Component)cancel);
    }

    protected abstract Class<T> getServiceClass();

    protected abstract void build(IModel var1, Form var2);

    protected void handleSubmit(T info) {
        this.getGeoServer().save(info);
    }

    protected abstract String getServiceName();
}

