/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.SelectionRemovalLink;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.data.workspace.WorkspaceNewPage;
import org.geoserver.web.data.workspace.WorkspaceProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.SimpleBookmarkableLink;

public class WorkspacePage
extends GeoServerSecuredPage {
    WorkspaceProvider provider = new WorkspaceProvider();
    GeoServerTablePanel<WorkspaceInfo> table = new GeoServerTablePanel<WorkspaceInfo>("table", (GeoServerDataProvider)this.provider, true){

        @Override
        protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<WorkspaceInfo> property) {
            if (property == WorkspaceProvider.NAME) {
                return WorkspacePage.this.workspaceLink(id, itemModel);
            }
            if (property == WorkspaceProvider.DEFAULT) {
                if (WorkspacePage.this.getCatalog().getDefaultWorkspace().equals(itemModel.getObject())) {
                    return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                }
                return new Label(id, "");
            }
            throw new IllegalArgumentException("No such property " + property.getName());
        }

        @Override
        protected void onSelectionUpdate(AjaxRequestTarget target) {
            WorkspacePage.this.removal.setEnabled(WorkspacePage.this.table.getSelection().size() > 0);
            target.addComponent((Component)WorkspacePage.this.removal);
        }
    };
    GeoServerDialog dialog;
    SelectionRemovalLink removal;

    public WorkspacePage() {
        this.add((Component)this.table);
        this.table.setOutputMarkupId(true);
        this.dialog = new GeoServerDialog("dialog");
        this.add((Component)this.dialog);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add((Component)new BookmarkablePageLink("addNew", WorkspaceNewPage.class));
        this.removal = new SelectionRemovalLink("removeSelected", this.table, this.dialog);
        header.add((Component)this.removal);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    Component workspaceLink(String id, IModel itemModel) {
        IModel nameModel = WorkspaceProvider.NAME.getModel(itemModel);
        return new SimpleBookmarkableLink(id, WorkspaceEditPage.class, nameModel, "name", (String)nameModel.getObject());
    }
}

