/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreProvider
extends GeoServerDataProvider<StoreInfo> {
    static final GeoServerDataProvider.Property<StoreInfo> TYPE = new GeoServerDataProvider.AbstractProperty<StoreInfo>("type"){

        @Override
        public IModel getModel(final IModel itemModel) {
            return new Model((Serializable)itemModel){

                public Object getObject() {
                    StoreInfo si = (StoreInfo)itemModel.getObject();
                    return this.getPropertyValue(si);
                }
            };
        }

        @Override
        public Object getPropertyValue(StoreInfo item) {
            if (item instanceof DataStoreInfo) {
                return "vector";
            }
            return "raster";
        }
    };
    static final GeoServerDataProvider.Property<StoreInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<StoreInfo>("workspace", "workspace.name");
    static final GeoServerDataProvider.Property<StoreInfo> NAME = new GeoServerDataProvider.BeanProperty<StoreInfo>("name", "name");
    static final GeoServerDataProvider.Property<StoreInfo> ENABLED = new GeoServerDataProvider.BeanProperty<StoreInfo>("enabled", "enabled");
    static final List<GeoServerDataProvider.Property<StoreInfo>> PROPERTIES = Arrays.asList(TYPE, WORKSPACE, NAME, ENABLED);
    WorkspaceInfo workspace;

    public StoreProvider() {
        this(null);
    }

    public StoreProvider(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    @Override
    protected List<StoreInfo> getItems() {
        return this.workspace == null ? this.getCatalog().getStores(StoreInfo.class) : this.getCatalog().getStoresByWorkspace(this.workspace, StoreInfo.class);
    }

    @Override
    protected List<GeoServerDataProvider.Property<StoreInfo>> getProperties() {
        return PROPERTIES;
    }

    @Override
    protected Comparator<StoreInfo> getComparator(SortParam sort) {
        return super.getComparator(sort);
    }

    public IModel model(Object object) {
        return new StoreInfoDetachableModel((StoreInfo)object);
    }

    static class StoreInfoDetachableModel
    extends LoadableDetachableModel {
        private static final long serialVersionUID = -6829878983583733186L;
        String id;

        public StoreInfoDetachableModel(StoreInfo store) {
            super((Object)store);
            this.id = store.getId();
        }

        protected Object load() {
            Catalog catalog = GeoServerApplication.get().getCatalog();
            StoreInfo storeInfo = catalog.getStore(this.id, StoreInfo.class);
            return storeInfo;
        }
    }
}

