/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.store.CoverageStoreNewPage;
import org.geoserver.web.data.store.DataAccessNewPage;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.opengis.coverage.grid.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewDataPage
extends GeoServerSecuredPage {
    private transient Map<String, DataAccessFactory> dataStores = this.getAvailableDataStores();
    private transient Map<String, Format> coverages = this.getAvailableCoverageStores();

    public NewDataPage() {
        boolean thereAreWorkspaces;
        boolean bl = thereAreWorkspaces = !this.getCatalog().getWorkspaces().isEmpty();
        if (!thereAreWorkspaces) {
            super.error((Serializable)((Object)((String)new ResourceModel("NewDataPage.noWorkspacesErrorMessage").getObject())));
        }
        Form storeForm = new Form("storeForm");
        this.add((Component)storeForm);
        ArrayList<String> sortedDsNames = new ArrayList<String>(this.getAvailableDataStores().keySet());
        Collections.sort(sortedDsNames);
        final CatalogIconFactory icons = CatalogIconFactory.get();
        ListView dataStoreLinks = new ListView("vectorResources", sortedDsNames){

            protected void populateItem(ListItem item) {
                final String dataStoreFactoryName = item.getModelObjectAsString();
                DataAccessFactory factory = (DataAccessFactory)NewDataPage.this.getAvailableDataStores().get(dataStoreFactoryName);
                String description = factory.getDescription();
                SubmitLink link = new SubmitLink("resourcelink"){

                    public void onSubmit() {
                        this.setResponsePage((Page)new DataAccessNewPage(dataStoreFactoryName));
                    }
                };
                link.setEnabled(thereAreWorkspaces);
                link.add((Component)new Label("resourcelabel", dataStoreFactoryName));
                item.add((Component)link);
                item.add((Component)new Label("resourceDescription", description));
                Image icon = new Image("storeIcon", icons.getStoreIcon(factory.getClass()));
                icon.add((IBehavior)new AttributeModifier("alt", true, (IModel)new Model((Serializable)((Object)""))));
                item.add((Component)icon);
            }
        };
        ArrayList<String> sortedCoverageNames = new ArrayList<String>();
        sortedCoverageNames.addAll(this.getAvailableCoverageStores().keySet());
        Collections.sort(sortedCoverageNames);
        ListView coverageLinks = new ListView("rasterResources", sortedCoverageNames){

            protected void populateItem(ListItem item) {
                final String coverageFactoryName = item.getModelObjectAsString();
                Map coverages = NewDataPage.this.getAvailableCoverageStores();
                Format format = (Format)coverages.get(coverageFactoryName);
                String description = format.getDescription();
                SubmitLink link = new SubmitLink("resourcelink"){

                    public void onSubmit() {
                        this.setResponsePage((Page)new CoverageStoreNewPage(coverageFactoryName));
                    }
                };
                link.setEnabled(thereAreWorkspaces);
                link.add((Component)new Label("resourcelabel", coverageFactoryName));
                item.add((Component)link);
                item.add((Component)new Label("resourceDescription", description));
                Image icon = new Image("storeIcon", icons.getStoreIcon(format.getClass()));
                icon.add((IBehavior)new AttributeModifier("alt", true, (IModel)new Model((Serializable)((Object)""))));
                item.add((Component)icon);
            }
        };
        storeForm.add((Component)dataStoreLinks);
        storeForm.add((Component)coverageLinks);
    }

    private Map<String, DataAccessFactory> getAvailableDataStores() {
        if (this.dataStores == null) {
            Iterator availableDataStores = DataAccessFinder.getAvailableDataStores();
            HashMap<String, DataAccessFactory> storeNames = new HashMap<String, DataAccessFactory>();
            while (availableDataStores.hasNext()) {
                DataAccessFactory factory = (DataAccessFactory)availableDataStores.next();
                storeNames.put(factory.getDisplayName(), factory);
            }
            this.dataStores = storeNames;
        }
        return this.dataStores;
    }

    private Map<String, Format> getAvailableCoverageStores() {
        if (this.coverages == null) {
            Format[] availableFormats = GridFormatFinder.getFormatArray();
            HashMap<String, Format> formatNames = new HashMap<String, Format>();
            for (Format format : availableFormats) {
                formatNames.put(format.getName(), format);
            }
            this.coverages = formatNames;
        }
        return this.coverages;
    }
}

