/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.store.StoreEditPanel;
import org.geoserver.web.data.store.StoreExtensionPoints;
import org.geoserver.web.data.store.StoreNameValidator;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geotools.coverage.grid.io.AbstractGridFormat;

abstract class AbstractCoverageStorePage
extends GeoServerSecuredPage {
    protected WorkspacePanel workspacePanel;
    private Form paramsForm;

    AbstractCoverageStorePage() {
    }

    void initUI(CoverageStoreInfo store) {
        AbstractGridFormat format = store.getFormat();
        if (format == null) {
            String msg = "Coverage Store factory not found";
            msg = (String)new ResourceModel("CoverageStoreEditPage.cantGetCoverageStoreFactory", msg).getObject();
            throw new IllegalArgumentException(msg);
        }
        Model model = new Model((Serializable)store);
        this.paramsForm = new Form("rasterStoreForm", (IModel)model);
        this.add((Component)this.paramsForm);
        this.paramsForm.add((Component)new Label("storeType", format.getName()));
        this.paramsForm.add((Component)new Label("storeTypeDescription", format.getDescription()));
        PropertyModel nameModel = new PropertyModel((Object)model, "name");
        TextParamPanel namePanel = new TextParamPanel("namePanel", (IModel)nameModel, (IModel)new ResourceModel("dataSrcName", "Data Source Name"), true, new IValidator[0]);
        this.paramsForm.add((Component)namePanel);
        this.paramsForm.add((Component)new TextParamPanel("descriptionPanel", (IModel)new PropertyModel((Object)model, "description"), (IModel)new ResourceModel("description", "Description"), false, new IValidator[0]));
        this.paramsForm.add((Component)new CheckBoxParamPanel("enabledPanel", (IModel)new PropertyModel((Object)model, "enabled"), (IModel)new ResourceModel("enabled", "Enabled")));
        this.workspacePanel = new WorkspacePanel("workspacePanel", (IModel)new PropertyModel((Object)model, "workspace"), (IModel)new ResourceModel("workspace", "Workspace"), true);
        this.paramsForm.add((Component)this.workspacePanel);
        GeoServerApplication app = this.getGeoServerApplication();
        StoreEditPanel storeEditPanel = StoreExtensionPoints.getStoreEditPanel("parametersPanel", this.paramsForm, (StoreInfo)store, app);
        this.paramsForm.add((Component)storeEditPanel);
        this.paramsForm.add((Component)new BookmarkablePageLink("cancel", StorePage.class));
        this.paramsForm.add((Component)this.saveLink());
        this.paramsForm.setDefaultButton((IFormSubmittingComponent)this.saveLink());
        this.paramsForm.add((Component)new FeedbackPanel("feedback"));
        StoreNameValidator storeNameValidator = new StoreNameValidator(this.workspacePanel.getFormComponent(), namePanel.getFormComponent(), store.getId());
        this.paramsForm.add((IFormValidator)storeNameValidator);
    }

    private AjaxSubmitLink saveLink() {
        return new AjaxSubmitLink("save", this.paramsForm){

            protected void onError(AjaxRequestTarget target, Form form) {
                super.onError(target, form);
                target.addComponent((Component)AbstractCoverageStorePage.this.paramsForm);
            }

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                CoverageStoreInfo info = (CoverageStoreInfo)form.getModelObject();
                try {
                    AbstractCoverageStorePage.this.onSave(info, target);
                }
                catch (IllegalArgumentException e) {
                    AbstractCoverageStorePage.this.paramsForm.error((Serializable)((Object)e.getMessage()));
                    target.addComponent((Component)AbstractCoverageStorePage.this.paramsForm);
                }
            }
        };
    }

    protected abstract void onSave(CoverageStoreInfo var1, AjaxRequestTarget var2) throws IllegalArgumentException;

    protected void clone(CoverageStoreInfo source, CoverageStoreInfo target) {
        target.setDescription(source.getDescription());
        target.setEnabled(source.isEnabled());
        target.setName(source.getName());
        target.setType(source.getType());
        target.setURL(source.getURL());
        target.setWorkspace(source.getWorkspace());
    }
}

