/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;

public class MetadataLinkEditor
extends Panel {
    private static final List<String> LINK_TYPES = Arrays.asList("FGDC", "TC211", "other");
    private ListView links;
    private Label noMetadata;
    private WebMarkupContainer table;

    public MetadataLinkEditor(String id, final IModel resourceModel) {
        super(id, resourceModel);
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add((Component)container);
        this.table = new WebMarkupContainer("table");
        this.table.setOutputMarkupId(true);
        container.add((Component)this.table);
        this.links = new ListView("links", (IModel)new PropertyModel((Object)resourceModel, "metadataLinks")){

            protected void populateItem(ListItem item) {
                item.add((IBehavior)new SimpleAttributeModifier("class", (CharSequence)(item.getIndex() % 2 == 0 ? "even" : "odd")));
                DropDownChoice dropDownChoice = new DropDownChoice("type", (IModel)new PropertyModel((Object)item.getModel(), "metadataType"), LINK_TYPES);
                dropDownChoice.setRequired(true);
                item.add((Component)dropDownChoice);
                FormComponentFeedbackBorder urlBorder = new FormComponentFeedbackBorder("urlBorder");
                item.add((Component)urlBorder);
                TextField format = new TextField("format", (IModel)new PropertyModel((Object)item.getModel(), "type"));
                format.setRequired(true);
                item.add((Component)format);
                TextField url = new TextField("metadataLinkURL", (IModel)new PropertyModel((Object)item.getModel(), "content"));
                url.add((IValidator)new UrlValidator());
                url.setRequired(true);
                urlBorder.add((Component)url);
                AjaxLink link = new AjaxLink("removeLink", item.getModel()){

                    public void onClick(AjaxRequestTarget target) {
                        ResourceInfo ri = (ResourceInfo)resourceModel.getObject();
                        ri.getMetadataLinks().remove(this.getModelObject());
                        MetadataLinkEditor.this.updateLinksVisibility();
                        target.addComponent((Component)container);
                    }
                };
                item.add((Component)link);
            }
        };
        this.links.setReuseItems(true);
        this.table.add((Component)this.links);
        this.noMetadata = new Label("noLinks", (IModel)new ResourceModel("noMetadataLinksSoFar"));
        container.add((Component)this.noMetadata);
        this.updateLinksVisibility();
        AjaxButton button = new AjaxButton("addlink"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ResourceInfo ri = (ResourceInfo)resourceModel.getObject();
                MetadataLinkInfo link = ri.getCatalog().getFactory().createMetadataLink();
                link.setMetadataType((String)LINK_TYPES.get(0));
                link.setType("text/plain");
                ri.getMetadataLinks().add(link);
                MetadataLinkEditor.this.updateLinksVisibility();
                target.addComponent((Component)container);
            }
        };
        this.add((Component)button);
    }

    private void updateLinksVisibility() {
        ResourceInfo ri = (ResourceInfo)this.getModelObject();
        boolean anyLink = ri.getMetadataLinks().size() > 0;
        this.table.setVisible(anyLink);
        this.noMetadata.setVisible(!anyLink);
    }
}

