/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.SelectionRemovalLink;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.layergroup.LayerGroupNewPage;
import org.geoserver.web.data.layergroup.LayerGroupProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;

public class LayerGroupPage
extends GeoServerSecuredPage {
    GeoServerTablePanel<LayerGroupInfo> table;
    GeoServerDialog dialog;
    SelectionRemovalLink removal;

    public LayerGroupPage() {
        LayerGroupProvider provider = new LayerGroupProvider();
        this.table = new GeoServerTablePanel<LayerGroupInfo>("table", (GeoServerDataProvider)provider, true){

            @Override
            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<LayerGroupInfo> property) {
                if (property == LayerGroupProvider.NAME) {
                    return LayerGroupPage.this.layerGroupLink(id, itemModel);
                }
                return null;
            }

            @Override
            protected void onSelectionUpdate(AjaxRequestTarget target) {
                LayerGroupPage.this.removal.setEnabled(LayerGroupPage.this.table.getSelection().size() > 0);
                target.addComponent((Component)LayerGroupPage.this.removal);
            }
        };
        this.add((Component)this.table);
        this.table.setOutputMarkupId(true);
        this.add((Component)this.table);
        this.dialog = new GeoServerDialog("dialog");
        this.add((Component)this.dialog);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add((Component)new BookmarkablePageLink("addNew", LayerGroupNewPage.class));
        this.removal = new SelectionRemovalLink("removeSelected", this.table, this.dialog);
        header.add((Component)this.removal);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    Component layerGroupLink(String id, IModel itemModel) {
        IModel groupNameModel = LayerGroupProvider.NAME.getModel(itemModel);
        String groupName = (String)groupNameModel.getObject();
        return new SimpleBookmarkableLink(id, LayerGroupEditPage.class, groupNameModel, "group", groupName);
    }
}

