/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.util.Collections;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.layergroup.LayerGroupPage;

public class LayerGroupNewPage
extends GeoServerSecuredPage {
    public LayerGroupNewPage() {
        LayerGroupInfo lg = this.getCatalog().getFactory().createLayerGroup();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)lg));
        this.add((Component)form);
        TextField name = new TextField("name");
        name.setRequired(true);
        name.add((IValidator)new GroupNameValidator());
        form.add((Component)name);
        form.add((Component)new SubmitLink("submit", form){

            public void onSubmit() {
                LayerGroupInfo lg = (LayerGroupInfo)this.getForm().getModelObject();
                Catalog catalog = LayerGroupNewPage.this.getCatalog();
                try {
                    catalog.add(lg);
                    lg = catalog.getLayerGroup(lg.getId());
                    this.setResponsePage(LayerGroupEditPage.class, new PageParameters("group=" + lg.getName()));
                }
                catch (Exception e) {
                    this.error(e);
                    LOGGER.log(Level.WARNING, "Error creating new layer group.", e);
                }
            }
        });
        form.add((Component)new SubmitLink("cancel", form){

            public void onSubmit() {
                this.setResponsePage(LayerGroupPage.class);
            }
        });
    }

    class GroupNameValidator
    extends AbstractValidator {
        GroupNameValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            String name = (String)validatable.getValue();
            if (LayerGroupNewPage.this.getCatalog().getLayerGroupByName(name) != null) {
                this.error(validatable, "duplicateGroupNameError", Collections.singletonMap("name", name));
            }
        }
    }
}

