/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.Serializable;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource
implements Comparable<Resource>,
Serializable {
    String name;
    String uri;
    boolean published;

    public void setPublished(boolean published) {
        this.published = published;
    }

    public Resource(Name name) {
        this.name = name.getLocalPart();
        this.uri = name.getURI();
    }

    public String getLocalName() {
        return this.name;
    }

    public Name getName() {
        return new NameImpl(this.uri, this.name);
    }

    public boolean isPublished() {
        return this.published;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(Resource o) {
        if (this.published && !o.published) {
            return -1;
        }
        if (!this.published && o.published) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return this.name + "(" + this.published + ")";
    }
}

