/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.data.layer.LayerDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerProvider
extends GeoServerDataProvider<LayerInfo> {
    static final GeoServerDataProvider.Property<LayerInfo> TYPE = new GeoServerDataProvider.BeanProperty<LayerInfo>("type", "type");
    static final GeoServerDataProvider.Property<LayerInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<LayerInfo>("workspace", "resource.store.workspace.name");
    static final GeoServerDataProvider.Property<LayerInfo> STORE = new GeoServerDataProvider.BeanProperty<LayerInfo>("store", "resource.store.name");
    static final GeoServerDataProvider.Property<LayerInfo> NAME = new GeoServerDataProvider.BeanProperty<LayerInfo>("name", "name");
    static final GeoServerDataProvider.Property<LayerInfo> ENABLED = new GeoServerDataProvider.AbstractProperty<LayerInfo>("enabled"){

        public Boolean getPropertyValue(LayerInfo item) {
            return item.enabled();
        }
    };
    static final GeoServerDataProvider.Property<LayerInfo> SRS = new GeoServerDataProvider.BeanProperty<LayerInfo>("SRS", "resource.SRS"){

        @Override
        public Comparator<LayerInfo> getComparator() {
            return new Comparator<LayerInfo>(){

                @Override
                public int compare(LayerInfo o1, LayerInfo o2) {
                    String[] srs2;
                    String[] srs1 = o1.getResource().getSRS().split(":");
                    if (srs1[0].equalsIgnoreCase((srs2 = o2.getResource().getSRS().split(":"))[0]) && srs1.length > 1 && srs2.length > 1) {
                        try {
                            return new Integer(srs1[1]).compareTo(new Integer(srs2[1]));
                        }
                        catch (NumberFormatException e) {
                            return srs1[1].compareTo(srs2[1]);
                        }
                    }
                    return srs1[0].compareToIgnoreCase(srs2[0]);
                }
            };
        }
    };
    static final List<GeoServerDataProvider.Property<LayerInfo>> PROPERTIES = Arrays.asList(TYPE, WORKSPACE, STORE, NAME, ENABLED, SRS);

    @Override
    protected List<LayerInfo> getItems() {
        return this.getCatalog().getLayers();
    }

    @Override
    protected List<GeoServerDataProvider.Property<LayerInfo>> getProperties() {
        return PROPERTIES;
    }

    public IModel model(Object object) {
        return new LayerDetachableModel((LayerInfo)object);
    }

    @Override
    protected Comparator<LayerInfo> getComparator(SortParam sort) {
        return super.getComparator(sort);
    }
}

